#pragma once

#include "Task.h"

class ExploreSectorTask :
	public Task
{
protected:
	MapSector* _sector;

	double _maxDistance;

public:
	static void generateNecessaryTasks(Environment* env);

	static SectorList prioritizeSectors(Environment* env);

	static double evaluateAptitudeForTask(MapSector* sector, Agent* agent);

	ExploreSectorTask(MapSector* sector, Environment* env);
	virtual ~ExploreSectorTask(void);

	MapSector* getSector();

	virtual void removeAgent(Agent* agent);

	virtual void calculatePriority();
	virtual double evaluateAptitude(Agent* agent);
	virtual void evaluateStatus();
	
	virtual void evaluateNeededUnits();

	virtual bool execute(Agent* agent);
};
