#pragma once

#include "task.h"

class BuildTask :
	public Task
{
protected:
	UnitType _workerType;
	UnitType _buildingType;

	TilePosition _buildingPos;
	Position _targetPosition;

	BuildingSpaceInfo* _plannedBuilding;

	bool _requiresUnits;

	Unit* _building;

	void initialize();

public:
	static void generateUnfinishedBuildTasks(Environment* env);

	BuildTask(UnitType buildingType, TilePosition pos, Environment* env);
	BuildTask(Unit* building, Environment* env);
	virtual ~BuildTask(void);

	double evaluateAptitude(Agent* agent);
	void evaluateStatus();
	
	void evaluateNeededUnits();

	TilePosition getBuildingPosition();
	UnitType getBuildingType();
	Unit* getBuilding();

	bool execute(Agent* agent);
};

