#include "BuildSupplyTask.h"
#include "Environment.h"
#include "BaseAgent.h"
#include "Agent.h"

#define TASK_PRIORITY_FACTOR			1000.0
#define MIN_FREE_SUPPLY					2
#define SUPPLY_PER_BUILDING_AGENT		16
#define SUPPLY_SCALE_FACTOR				2
#define GENERATE_FREQ					100

void BuildSupplyTask::generateNecessaryTasks(Environment* env)
{
	if (Broodwar->getFrameCount()%GENERATE_FREQ != 0) return;

	int currentSupply = env->getCurrentSupply();

	TaskSet buildSupplyTasks = env->getFilteredTasks(BUILD_SUPPLY_TASK);
	int futureSupply = SUPPLY_PER_BUILDING_AGENT*buildSupplyTasks.size();

	int requiredSupply = env->getRequiredSupply()*SUPPLY_SCALE_FACTOR;
	int totalSupply = env->getTotalSupply();

	if ((currentSupply + futureSupply - requiredSupply) >= MIN_FREE_SUPPLY) return;

	AgentMap bases = env->getFilteredAgents(BASE_AGENT);

	while ((currentSupply + futureSupply - requiredSupply) < MIN_FREE_SUPPLY)
	{
		if ((totalSupply + futureSupply) >= MAX_SUPPLY) break;

		bool foundPosition = false;

		for(AgentMap::iterator i = bases.begin(); i != bases.end(); i++)
		{
			BaseAgent* base = (BaseAgent*)(*i).second;

			if (base->getUnit()->isLifted()) continue;

			TilePosition position = env->getBestPosition(UnitTypes::Terran_Supply_Depot, base->getUnitPosition());

			if (position != TilePositions::None)
			{
				//Broodwar->printf("Generating BuildSupplyTask task.");
				env->addTask(new BuildSupplyTask(position, env));

				env->generateValidPositions();
				futureSupply += SUPPLY_PER_BUILDING_AGENT;
				foundPosition = true;
				break;
			}
		}

		if (!foundPosition) break;
	}
}

BuildSupplyTask::BuildSupplyTask(TilePosition pos, Environment* env) : BuildTask(UnitTypes::Terran_Supply_Depot, pos, env)
{
	_types.insert(BUILD_SUPPLY_TASK);
}

BuildSupplyTask::BuildSupplyTask(Unit* building, Environment* env) : BuildTask(building, env)
{
	_types.insert(BUILD_SUPPLY_TASK);
}

BuildSupplyTask::~BuildSupplyTask(void)
{
}

void BuildSupplyTask::calculatePriority()
{
	int currentSupply = max(_env->getCurrentSupply(), 1);
	int requiredSupply = _env->getRequiredSupply()*SUPPLY_SCALE_FACTOR;

	TaskSet buildSupplyTasks = _env->getFilteredTasks(BUILD_SUPPLY_TASK, _creationFrame);
	int futureSupply = SUPPLY_PER_BUILDING_AGENT*buildSupplyTasks.size();

	double supplyFactor = (requiredSupply + MIN_FREE_SUPPLY)/(double)(currentSupply + futureSupply);

	double prePriority = TASK_PRIORITY_FACTOR*supplyFactor;

	_priority = scalePriority(prePriority, MAX_BUILD_PRIORITY, MIN_BUILD_PRIORITY);
}
