#include "BuildStarportTask.h"
#include "Environment.h"
#include "BaseAgent.h"
#include "Agent.h"
#include "AiLogger.h"

#define TASK_PRIORITY_FACTOR		1000.0
#define WORKER_AGENTS_PER_STARPORT	12
#define WORKER_BONUS				6
#define DEPOT_BONUS					0
#define MAX_STARPORTS				6	
#define GENERATE_FREQ				100

void BuildStarportTask::generateNecessaryTasks(Environment* env)
{
	if (Broodwar->getFrameCount()%GENERATE_FREQ != 0) return;

	if(!env->getFilteredAgents(UnitTypes::Terran_Factory).size()) return;

	int starportCount = env->getFilteredAgents(UnitTypes::Terran_Starport).size();

	if (starportCount >= MAX_STARPORTS) return;

	int supplyDepotCount = env->getFilteredAgents(UnitTypes::Terran_Supply_Depot).size() + DEPOT_BONUS;

	int futureStarports = env->getFilteredTasks(BUILD_STARPORT_TASK).size();
	int totalstarports = starportCount + futureStarports;

	if (supplyDepotCount <= totalstarports) return;

	AgentMap bases = env->getFilteredAgents(BASE_AGENT);

	int totalMineralWorkers = env->getFilteredAgents(RECOLLECT_MIN_TASK).size() + WORKER_BONUS;

	while ((supplyDepotCount > totalstarports) && (totalstarports*WORKER_AGENTS_PER_STARPORT < totalMineralWorkers))
	{
		bool foundPosition = false;

		for(AgentMap::iterator i = bases.begin(); i != bases.end(); i++)
		{
			BaseAgent* base = (BaseAgent*)(*i).second;

			if (base->getUnit()->isLifted()) continue;

			TilePosition position = env->getBestPosition(UnitTypes::Terran_Starport, base->getUnitPosition());

			if (position != TilePositions::None)
			{
				//Broodwar->printf("Generating BuildStarportTask task.");
				env->addTask(new BuildStarportTask(position, env));

				env->generateValidPositions();
				totalstarports++;
				foundPosition = true;
				break;
			}
		}

		if (!foundPosition) break;
	}
}

BuildStarportTask::BuildStarportTask(TilePosition pos, Environment* env) : BuildTask(UnitTypes::Terran_Starport, pos, env)
{
	_types.insert(BUILD_STARPORT_TASK);
}

BuildStarportTask::BuildStarportTask(Unit* building, Environment* env) : BuildTask(building, env)
{
	_types.insert(BUILD_STARPORT_TASK);
}

BuildStarportTask::~BuildStarportTask(void)
{
}

void BuildStarportTask::calculatePriority()
{
	int futureStarports = _env->getFilteredTasks(BUILD_STARPORT_TASK, _creationFrame).size();
	int starportCount = 1 + (int)_env->getFilteredAgents(UnitTypes::Terran_Starport).size() + futureStarports;
	int supplyDepotCount = _env->getFilteredAgents(UnitTypes::Terran_Supply_Depot).size() + DEPOT_BONUS;

	int totalMineralWorkers = _env->getFilteredAgents(RECOLLECT_MIN_TASK).size() + WORKER_BONUS;

	double workerFactor = totalMineralWorkers/(double)(starportCount*WORKER_AGENTS_PER_STARPORT);
	double supplyDepotFactor = supplyDepotCount/(double)(starportCount + supplyDepotCount);

	double prePriority = TASK_PRIORITY_FACTOR*workerFactor*supplyDepotFactor;

	_priority = scalePriority(prePriority, MAX_BUILD_PRIORITY, MIN_BUILD_PRIORITY);
}
