#include "BuildScienceFacilityTask.h"
#include "Environment.h"
#include "BaseAgent.h"
#include "Agent.h"
#include "AiLogger.h"

#define TASK_PRIORITY_FACTOR		1000.0
#define MIN_ATTACKER_AGENTS			15
#define MAX_BUILD_TASKS				1
#define MAX_SCIENCEFACILITIES		1
#define MIN_COMMANDS				2
#define GENERATE_FREQ				100

void BuildScienceFacilityTask::generateNecessaryTasks(Environment* env)
{
	if (Broodwar->getFrameCount()%GENERATE_FREQ != 0) return;

	if(!env->getFilteredAgents(UnitTypes::Terran_Starport).size()) return;
	
	int futureScienceFacilities = env->getFilteredTasks(BUILD_SCIENCE_FACILITY_TASK).size();

	if (futureScienceFacilities >= MAX_BUILD_TASKS) return;

	AgentMap attackers = env->getFilteredAgents(ATTACKER_AGENT);
	int attackerCount = attackers.size() - Agent::filterMap(&attackers, WORKER_AGENT).size();

	int minAttackers = MIN_ATTACKER_AGENTS;

	if (attackerCount < minAttackers) return;

	int scienceFacilitiesCount = env->getFilteredAgents(UnitTypes::Terran_Science_Facility).size();

	if ((scienceFacilitiesCount + futureScienceFacilities) >= MAX_SCIENCEFACILITIES) return;

	AgentMap bases = env->getFilteredAgents(BASE_AGENT);

	if (bases.size() < MIN_COMMANDS) return;

	while ((scienceFacilitiesCount + futureScienceFacilities) < MAX_SCIENCEFACILITIES)
	{
		bool foundPosition = false;

		for(AgentMap::iterator i = bases.begin(); i != bases.end(); i++)
		{
			BaseAgent* base = (BaseAgent*)(*i).second;

			if (base->getUnit()->isLifted()) continue;

			TilePosition position = env->getBestPosition(UnitTypes::Terran_Science_Facility, base->getUnitPosition());

			if (position != TilePositions::None)
			{
				env->addTask(new BuildScienceFacilityTask(position, env));

				env->generateValidPositions();
				futureScienceFacilities++;
				foundPosition = true;
				break;
			}
		}

		if (!foundPosition) break;
	}
}

BuildScienceFacilityTask::BuildScienceFacilityTask(TilePosition pos, Environment* env) : BuildTask(UnitTypes::Terran_Science_Facility, pos, env)
{
	_types.insert(BUILD_SCIENCE_FACILITY_TASK);
}

BuildScienceFacilityTask::BuildScienceFacilityTask(Unit* building, Environment* env) : BuildTask(building, env)
{
	_types.insert(BUILD_SCIENCE_FACILITY_TASK);
}

BuildScienceFacilityTask::~BuildScienceFacilityTask(void)
{
}

void BuildScienceFacilityTask::calculatePriority()
{
	AgentMap attackers = _env->getFilteredAgents(ATTACKER_AGENT);
	int attackerCount = attackers.size() - Agent::filterMap(&attackers, WORKER_AGENT).size() - MIN_ATTACKER_AGENTS;
	attackerCount = max(0, attackerCount);

	double prePriority = TASK_PRIORITY_FACTOR*attackerCount;

	_priority = scalePriority(prePriority, MAX_BUILD_PRIORITY, MIN_BUILD_PRIORITY);
}
