#include "BuildRefineryTask.h"
#include "Environment.h"
#include "BaseAgent.h"
#include "Agent.h"

#define TASK_PRIORITY_FACTOR		900.0
#define MINERS_PER_REFINERY			6
#define GENERATE_FREQ				100

void BuildRefineryTask::generateNecessaryTasks(Environment* env)
{
	if (Broodwar->getFrameCount()%GENERATE_FREQ != 0) return;

	//if (env->getRequiredGas() <= 0) return;

	AgentMap bases = env->getFilteredAgents(BASE_AGENT);

	for(AgentMap::iterator i = bases.begin(); i != bases.end(); i++)
	{
		BaseAgent* base = (BaseAgent*)(*i).second;

		if (base->getUnit()->isLifted()) continue;

		UnitSet* geysers = base->getGeysers();
		for(UnitSet::iterator i = geysers->begin(); i != geysers->end(); i++)
		{
			Unit* geyser = (*i);

			if (!env->isTaskTarget(geyser, BUILD_REFINERY_TASK))
			{
				//Broodwar->printf("Generating BuildRefineryTask task.");
				env->addTask(new BuildRefineryTask(geyser, env));

				env->generateValidPositions();
			}
		}
	}
}

BuildRefineryTask::BuildRefineryTask(Unit* geyser, Environment* env) : BuildTask(geyser, env)
{
	_types.insert(BUILD_REFINERY_TASK);

	_geyser = geyser;

	_env->addTaskTarget(_geyser, BUILD_REFINERY_TASK);
}

BuildRefineryTask::~BuildRefineryTask(void)
{
	_env->removeTaskTarget(_geyser, BUILD_REFINERY_TASK);
}

void BuildRefineryTask::calculatePriority()
{
	int numMineralWorkers = _env->getFilteredAgents(RECOLLECT_MIN_TASK).size();
	int numRefineries = _env->getFilteredAgents(UnitTypes::Terran_Refinery).size();

	double workerFactor = numMineralWorkers/(double)((1 + numRefineries)*MINERS_PER_REFINERY);

	double prePriority = TASK_PRIORITY_FACTOR*workerFactor;

	_priority = scalePriority(prePriority, MAX_BUILD_PRIORITY, MIN_BUILD_PRIORITY);
}
