#include "BuildFactoryTask.h"
#include "Environment.h"
#include "BaseAgent.h"
#include "Agent.h"
#include "AiLogger.h"

#define TASK_PRIORITY_FACTOR		1000.0
#define WORKER_AGENTS_PER_FACTORY	18
#define WORKER_BONUS				8
#define DEPOT_BONUS					0
#define MAX_FACTORIES				3
#define GENERATE_FREQ				100

void BuildFactoryTask::generateNecessaryTasks(Environment* env)
{
	if (Broodwar->getFrameCount()%GENERATE_FREQ != 0) return;

	if(!env->getFilteredAgents(UnitTypes::Terran_Barracks).size()) return;

	int factoryCount = env->getFilteredAgents(UnitTypes::Terran_Factory).size();

	if (factoryCount >= MAX_FACTORIES) return;

	int supplyDepotCount = env->getFilteredAgents(UnitTypes::Terran_Supply_Depot).size() + DEPOT_BONUS;

	int futureFactories = env->getFilteredTasks(BUILD_FACTORY_TASK).size();
	int totalFactories = factoryCount + futureFactories;

	if (supplyDepotCount <= totalFactories) return;

	AgentMap bases = env->getFilteredAgents(BASE_AGENT);

	int totalMineralWorkers = env->getFilteredAgents(RECOLLECT_MIN_TASK).size() + WORKER_BONUS;

	while ((supplyDepotCount > totalFactories) && (totalFactories*WORKER_AGENTS_PER_FACTORY < totalMineralWorkers))
	{
		bool foundPosition = false;

		for(AgentMap::iterator i = bases.begin(); i != bases.end(); i++)
		{
			BaseAgent* base = (BaseAgent*)(*i).second;

			if (base->getUnit()->isLifted()) continue;

			TilePosition position = env->getBestPosition(UnitTypes::Terran_Factory, base->getUnitPosition());

			if (position != TilePositions::None)
			{
				//Broodwar->printf("Generating BuildFactoryTask task.");
				env->addTask(new BuildFactoryTask(position, env));

				env->generateValidPositions();
				totalFactories++;
				foundPosition = true;
				break;
			}
		}

		if (!foundPosition) break;
	}
}

BuildFactoryTask::BuildFactoryTask(TilePosition pos, Environment* env) : BuildTask(UnitTypes::Terran_Factory, pos, env)
{
	_types.insert(BUILD_FACTORY_TASK);
}

BuildFactoryTask::BuildFactoryTask(Unit* building, Environment* env) : BuildTask(building, env)
{
	_types.insert(BUILD_FACTORY_TASK);
}

BuildFactoryTask::~BuildFactoryTask(void)
{
}

void BuildFactoryTask::calculatePriority()
{
	int futureFactories = _env->getFilteredTasks(BUILD_FACTORY_TASK, _creationFrame).size();
	int factoryCount = 1 + (int)_env->getFilteredAgents(UnitTypes::Terran_Factory).size() + futureFactories;
	int supplyDepotCount = _env->getFilteredAgents(UnitTypes::Terran_Supply_Depot).size() + DEPOT_BONUS;

	int totalMineralWorkers = _env->getFilteredAgents(RECOLLECT_MIN_TASK).size() + WORKER_BONUS;

	double workerFactor = totalMineralWorkers/(double)(factoryCount*WORKER_AGENTS_PER_FACTORY);
	double supplyDepotFactor = supplyDepotCount/(double)(factoryCount + supplyDepotCount);

	double prePriority = TASK_PRIORITY_FACTOR*workerFactor*supplyDepotFactor;

	_priority = scalePriority(prePriority, MAX_BUILD_PRIORITY, MIN_BUILD_PRIORITY);
}
