#include "BuildEngineeringTask.h"
#include "Environment.h"
#include "BaseAgent.h"
#include "Agent.h"
#include "AiLogger.h"

#define TASK_PRIORITY_FACTOR		1000.0
#define MIN_ATTACKER_AGENTS			15
#define MAX_BUILD_TASKS				1
#define MAX_ENGINEERING_BAYS		1
#define GENERATE_FREQ				100

void BuildEngineeringTask::generateNecessaryTasks(Environment* env)
{
	if (Broodwar->getFrameCount()%GENERATE_FREQ != 0) return;

	if(!env->getFilteredAgents(UnitTypes::Terran_Comsat_Station).size()) return;
	
	int futureEngineeringBays = env->getFilteredTasks(BUILD_ENGINEERING_TASK).size();

	if (futureEngineeringBays >= MAX_BUILD_TASKS) return;

	AgentMap attackers = env->getFilteredAgents(ATTACKER_AGENT);
	int attackerCount = attackers.size() - Agent::filterMap(&attackers, WORKER_AGENT).size();

	int minAttackers = MIN_ATTACKER_AGENTS;

	if (attackerCount < minAttackers) return;

	int engineeringBayCount = env->getFilteredAgents(UnitTypes::Terran_Engineering_Bay).size();

	if ((engineeringBayCount + futureEngineeringBays) >= MAX_ENGINEERING_BAYS) return;

	AgentMap bases = env->getFilteredAgents(BASE_AGENT);

	while ((engineeringBayCount + futureEngineeringBays) < MAX_ENGINEERING_BAYS)
	{
		bool foundPosition = false;

		for(AgentMap::iterator i = bases.begin(); i != bases.end(); i++)
		{
			BaseAgent* base = (BaseAgent*)(*i).second;

			if (base->getUnit()->isLifted()) continue;

			TilePosition position = env->getBestPosition(UnitTypes::Terran_Engineering_Bay, base->getUnitPosition());

			if (position != TilePositions::None)
			{
				//Broodwar->printf("Generating BuildEngineeringTask task.");
				env->addTask(new BuildEngineeringTask(position, env));

				env->generateValidPositions();
				futureEngineeringBays++;
				foundPosition = true;
				break;
			}
		}

		if (!foundPosition) break;
	}
}

BuildEngineeringTask::BuildEngineeringTask(TilePosition pos, Environment* env) : BuildTask(UnitTypes::Terran_Engineering_Bay, pos, env)
{
	_types.insert(BUILD_ENGINEERING_TASK);
}

BuildEngineeringTask::BuildEngineeringTask(Unit* building, Environment* env) : BuildTask(building, env)
{
	_types.insert(BUILD_ENGINEERING_TASK);
}

BuildEngineeringTask::~BuildEngineeringTask(void)
{
}

void BuildEngineeringTask::calculatePriority()
{
	AgentMap attackers = _env->getFilteredAgents(ATTACKER_AGENT);
	int attackerCount = attackers.size() - Agent::filterMap(&attackers, WORKER_AGENT).size() - MIN_ATTACKER_AGENTS;
	attackerCount = max(0, attackerCount);

	double prePriority = TASK_PRIORITY_FACTOR*attackerCount;

	_priority = scalePriority(prePriority, MAX_BUILD_PRIORITY, MIN_BUILD_PRIORITY);
}
