#include "BuildCommandTask.h"
#include "Environment.h"
#include "BaseAgent.h"
#include "Agent.h"
#include "AiLogger.h"

#define TASK_PRIORITY_FACTOR		5000.0
#define MAX_BUILD_TASKS				1
#define MAX_UNMINED_RESOURCES		4
#define WORKER_AGENTS_PER_PATCH		3
#define MIN_ATTACKER_AGENTS			10
#define GENERATE_FREQ				1000

void BuildCommandTask::generateNecessaryTasks(Environment* env)
{
	if (Broodwar->getFrameCount()%GENERATE_FREQ != 0) return;

	int futureCommands = env->getFilteredTasks(BUILD_COMMAND_TASK).size();

	if (futureCommands >= MAX_BUILD_TASKS) return;
	
	int futureMoves = env->getFilteredTasks(MOVE_COMMAND_TASK).size();

	if (futureMoves > 0) return;

	AgentMap attackers = env->getFilteredAgents(ATTACKER_AGENT);
	int attackerCount = attackers.size() - Agent::filterMap(&attackers, WORKER_AGENT).size();

	int minAttackers = MIN_ATTACKER_AGENTS;

	if (attackerCount < minAttackers) return;

	AgentMap bases = env->getFilteredAgents(BASE_AGENT);

	int mineralCount = 0;
	for(AgentMap::iterator i = bases.begin(); i != bases.end(); i++)
	{
		BaseAgent* base = (BaseAgent*)(*i).second;
		mineralCount += base->getMineralPatches()->size();
	}

	int mineralMiners = env->getFilteredAgents(RECOLLECT_MIN_TASK).size();

	int unminedResources = mineralCount - mineralMiners/WORKER_AGENTS_PER_PATCH;

	if (unminedResources > (int)(MAX_UNMINED_RESOURCES*bases.size())) return;

	while (futureCommands < MAX_BUILD_TASKS)
	{
		TilePosition position = env->getBestCommandPosition();

		if (position == TilePositions::None) break;

		//Broodwar->printf("Generating BuildCommandTask task.");
		env->addTask(new BuildCommandTask(position, env));

		env->generateValidPositions();
		futureCommands++;
	}
}

BuildCommandTask::BuildCommandTask(TilePosition pos, Environment* env) : BuildTask(UnitTypes::Terran_Command_Center, pos, env)
{
	_types.insert(BUILD_COMMAND_TASK);
}

BuildCommandTask::BuildCommandTask(Unit* building, Environment* env) : BuildTask(building, env)
{
	_types.insert(BUILD_COMMAND_TASK);
}

BuildCommandTask::~BuildCommandTask(void)
{
}

void BuildCommandTask::calculatePriority()
{
	AgentMap bases = _env->getFilteredAgents(BASE_AGENT);

	int mineralMiners = _env->getFilteredAgents(RECOLLECT_MIN_TASK).size();

	int mineralCount = 0;

	for(AgentMap::iterator i = bases.begin(); i != bases.end(); i++)
	{
		BaseAgent* base = (BaseAgent*)(*i).second;
		mineralCount += base->getMineralPatches()->size();
	}

	int unminedResources = mineralCount - mineralMiners/WORKER_AGENTS_PER_PATCH;

	int resValue = max(0, (int)(MAX_UNMINED_RESOURCES*bases.size() - unminedResources));

	double prePriority = resValue*TASK_PRIORITY_FACTOR;

	_priority = scalePriority(prePriority, MAX_BUILD_PRIORITY, MIN_BUILD_PRIORITY);
}
