#include "BuildBarracksTask.h"
#include "Environment.h"
#include "BaseAgent.h"
#include "Agent.h"
#include "AiLogger.h"

#define TASK_PRIORITY_FACTOR		3000.0
#define WORKER_AGENTS_PER_BARRACKS	14
#define WORKER_BONUS				8
#define DEPOT_BONUS					1
#define MAX_BARRACKS				6	
#define GENERATE_FREQ				100

void BuildBarracksTask::generateNecessaryTasks(Environment* env)
{
	if (Broodwar->getFrameCount()%GENERATE_FREQ != 0) return;

	int barracksCount = env->getFilteredAgents(UnitTypes::Terran_Barracks).size();

	if (barracksCount >= MAX_BARRACKS) return;

	int supplyDepotCount = env->getFilteredAgents(UnitTypes::Terran_Supply_Depot).size() + DEPOT_BONUS;

	int futureBarracks = env->getFilteredTasks(BUILD_BARRACKS_TASK).size();
	int totalBarracks = barracksCount + futureBarracks;

	if (supplyDepotCount <= totalBarracks) return;

	AgentMap bases = env->getFilteredAgents(BASE_AGENT);

	int totalMineralWorkers = env->getFilteredAgents(RECOLLECT_MIN_TASK).size() + WORKER_BONUS;

	while ((supplyDepotCount > totalBarracks) && (totalBarracks*WORKER_AGENTS_PER_BARRACKS < totalMineralWorkers))
	{
		bool foundPosition = false;

		for(AgentMap::iterator i = bases.begin(); i != bases.end(); i++)
		{
			BaseAgent* base = (BaseAgent*)(*i).second;

			if (base->getUnit()->isLifted()) continue;

			TilePosition position = env->getBestPosition(UnitTypes::Terran_Barracks, base->getUnitPosition());

			if (position != TilePositions::None)
			{
				//Broodwar->printf("Generating BuildBarracksTask task.");
				env->addTask(new BuildBarracksTask(position, env));

				env->generateValidPositions();
				totalBarracks++;
				foundPosition = true;
				break;
			}
		}

		if (!foundPosition) break;
	}
}

BuildBarracksTask::BuildBarracksTask(TilePosition pos, Environment* env) : BuildTask(UnitTypes::Terran_Barracks, pos, env)
{
	_types.insert(BUILD_BARRACKS_TASK);
}

BuildBarracksTask::BuildBarracksTask(Unit* building, Environment* env) : BuildTask(building, env)
{
	_types.insert(BUILD_BARRACKS_TASK);
}

BuildBarracksTask::~BuildBarracksTask(void)
{
}

void BuildBarracksTask::calculatePriority()
{
	int futureBarracks = _env->getFilteredTasks(BUILD_BARRACKS_TASK, _creationFrame).size();
	int barracksCount = 1 + (int)_env->getFilteredAgents(UnitTypes::Terran_Barracks).size() + futureBarracks;
	int supplyDepotCount = _env->getFilteredAgents(UnitTypes::Terran_Supply_Depot).size() + DEPOT_BONUS;

	int totalMineralWorkers = _env->getFilteredAgents(RECOLLECT_MIN_TASK).size() + WORKER_BONUS;

	double workerFactor = totalMineralWorkers/(double)(barracksCount*WORKER_AGENTS_PER_BARRACKS);
	double supplyDepotFactor = supplyDepotCount/(double)(barracksCount + supplyDepotCount);

	double prePriority = TASK_PRIORITY_FACTOR*workerFactor*supplyDepotFactor;

	_priority = scalePriority(prePriority, MAX_BUILD_PRIORITY, MIN_BUILD_PRIORITY);
}
