#include "BuildAcademyTask.h"
#include "Environment.h"
#include "BaseAgent.h"
#include "Agent.h"
#include "AiLogger.h"

#define TASK_PRIORITY_FACTOR		1000.0
#define MIN_ATTACKER_AGENTS			5
#define MAX_BUILD_TASKS				1
#define MAX_ACADEMIES				1
#define GENERATE_FREQ				100

void BuildAcademyTask::generateNecessaryTasks(Environment* env)
{
	if (Broodwar->getFrameCount()%GENERATE_FREQ != 0) return;

	int futureAcademies = env->getFilteredTasks(BUILD_ACADEMY_TASK).size();

	if (futureAcademies >= MAX_BUILD_TASKS) return;

	AgentMap attackers = env->getFilteredAgents(ATTACKER_AGENT);
	int attackerCount = attackers.size() - Agent::filterMap(&attackers, WORKER_AGENT).size();

	int minAttackers = MIN_ATTACKER_AGENTS;

	if (attackerCount < minAttackers) return;

	int academyCount = env->getFilteredAgents(UnitTypes::Terran_Academy).size();

	if ((academyCount + futureAcademies) >= MAX_ACADEMIES)  return;

	AgentMap bases = env->getFilteredAgents(BASE_AGENT);

	while ((academyCount + futureAcademies) < MAX_ACADEMIES)
	{
		bool foundPosition = false;

		for(AgentMap::iterator i = bases.begin(); i != bases.end(); i++)
		{
			BaseAgent* base = (BaseAgent*)(*i).second;

			if (base->getUnit()->isLifted()) continue;

			TilePosition position = env->getBestPosition(UnitTypes::Terran_Academy, base->getUnitPosition());

			if (position != TilePositions::None)
			{
				//Broodwar->printf("Generating BuildAcademyTask task.");
				env->addTask(new BuildAcademyTask(position, env));

				env->generateValidPositions();
				futureAcademies++;
				foundPosition = true;
				break;
			}
		}

		if (!foundPosition) break;
	}
}

BuildAcademyTask::BuildAcademyTask(TilePosition pos, Environment* env) : BuildTask(UnitTypes::Terran_Academy, pos, env)
{
	_types.insert(BUILD_ACADEMY_TASK);
}

BuildAcademyTask::BuildAcademyTask(Unit* building, Environment* env) : BuildTask(building, env)
{
	_types.insert(BUILD_ACADEMY_TASK);
}

BuildAcademyTask::~BuildAcademyTask(void)
{
}

void BuildAcademyTask::calculatePriority()
{
	AgentMap attackers = _env->getFilteredAgents(ATTACKER_AGENT);
	int attackerCount = attackers.size() - Agent::filterMap(&attackers, WORKER_AGENT).size() - MIN_ATTACKER_AGENTS;
	attackerCount = max(0, attackerCount);

	double prePriority = TASK_PRIORITY_FACTOR*attackerCount;

	_priority = scalePriority(prePriority, MAX_BUILD_PRIORITY, MIN_BUILD_PRIORITY);
}
