#pragma once

#include "Task.h"

class AttackUnitTask :
	public Task
{
protected:
	Unit* _target;
	double _minAptitude;

public:
	static void generateNecessaryTasks(Environment* env);

	AttackUnitTask(Unit* target, Environment* env);
	virtual ~AttackUnitTask(void);

	Unit* getTarget();

	virtual void addAgent(Agent* agent);
	virtual void removeAgent(Agent* agent);

	virtual double evaluateAptitude(Agent* agent);
	virtual void evaluateStatus();
	virtual void calculatePriority();
	
	virtual void evaluateNeededUnits();

	virtual bool execute(Agent* agent);
};
