#pragma once

#include "Task.h"

class AssaultSectorTask :
	public Task
{
protected:
	MapSector* _sector;
	int _assaultCount;

	bool _isAssaultReady;
	unsigned int _unitsNeeded;

	int _readyRange;
	Position _groupPosition;

	double _airStrength;
	double _groundStrength;
	double _minimumAttackAirStrength;
	double _minimumAttackGroundStrength;

	double _enemyAirStrength;
	double _enemyGroundStrength;
	double _minimumDefenseAirStrength;
	double _minimumDefenseGroundStrength;

	Unit* _targetEnemy;
	Agent* _centerAgent;

	UnitTypeCountMap _unitTypeCounts;

	void evaluateAssaultReadyness();

	bool marineExecute(Agent* agent);
	bool medicExecute(Agent* agent);
	bool wraithExecute(Agent* agent);
	bool tankExecute(Agent* agent);
	bool siegeExecute(Agent* agent);

public:
	static void generateNecessaryTasks(Environment* env);

	static SectorList prioritizeSectors(Environment* env);

	static double evaluateAptitudeForTask(MapSector* sector, Agent* agent, Position groupPosition = Positions::None);

	AssaultSectorTask(MapSector* sector, Environment* env);
	virtual ~AssaultSectorTask(void);

	virtual void addAgent(Agent* agent);
	virtual void removeAgent(Agent* agent);

	MapSector* getSector();
	int getReadyRange();
	Position getGroupPosition();

	bool isAssaultReady();

	double getAirStrength();
	double getGroundStrength();
	double getMinimumAttackAirStrength();
	double getMinimumAttackGroundStrength();

	double getEnemyAirStrength();
	double getEnemyGroundStrength();
	double getMinimumDefenseAirStrength();
	double getMinimumDefenseGroundStrength();

	Unit* getTargetEnemy();

	virtual void calculatePriority();
	virtual double evaluateAptitude(Agent* agent);
	virtual void evaluateStatus();
	
	virtual void evaluateNeededUnits();

	virtual bool execute(Agent* agent);
};
