#pragma once

#include "task.h"

class AddonBuildTask :
	public Task
{
protected:
	UnitType _sourceBuildingType;
	UnitType _buildingType;

	bool _requiresUnits;

	Unit* _building;

	void initialize();

public:
	AddonBuildTask(UnitType buildingType, Environment* env);
	virtual ~AddonBuildTask(void);

	virtual void addAgent(Agent* agent);
	virtual void removeAgent(Agent* agent);

	virtual void calculatePriority() = 0;
	double evaluateAptitude(Agent* agent);
	void evaluateStatus();
	
	void evaluateNeededUnits();

	UnitType getBuildingType();
	Unit* getBuilding();

	bool execute(Agent* agent);
};

