#include "AddonBuildMachineShopTask.h"
#include "Environment.h"
#include "BaseAgent.h"
#include "Agent.h"

#define TASK_PRIORITY_FACTOR		100000.0

void AddonBuildMachineShopTask::generateNecessaryTasks(Environment* env)
{
	AgentMap factories = env->getFilteredAgents(BWAPI::UnitTypes::Terran_Factory);

	int freefactories = 0;
	for(AgentMap::iterator i = factories.begin(); i != factories.end(); i++)
	{
		BaseAgent* agent = (BaseAgent*)(*i).second;
		Unit* factory = agent->getUnit();

		if (factory->isLifted()) continue;
		if (factory->getAddon() != NULL) continue;
		if (env->isTaskTarget(factory, ADDON_BUILD_TASK)) continue;

		freefactories++;
	}
	
	int futureFactories = env->getFilteredTasks(ADDON_MACHINE_SHOP_TASK).size();

	//if (futureComSats >= freefactories) return;

	while (futureFactories < freefactories)
	{
		//Broodwar->printf("Generating AddonBuildMachineShopTask task.");
		env->addTask(new AddonBuildMachineShopTask(env));

		env->generateValidPositions();
		futureFactories++;
	}
}

AddonBuildMachineShopTask::AddonBuildMachineShopTask(Environment* env) : AddonBuildTask(UnitTypes::Terran_Machine_Shop, env)
{
	_types.insert(ADDON_MACHINE_SHOP_TASK);
}

AddonBuildMachineShopTask::~AddonBuildMachineShopTask(void)
{
}

void AddonBuildMachineShopTask::calculatePriority()
{
	double prePriority = TASK_PRIORITY_FACTOR;

	_priority = scalePriority(prePriority, MAX_BUILD_PRIORITY, MIN_BUILD_PRIORITY);
}