#include "AddonBuildControlTowerTask.h"
#include "Environment.h"
#include "BaseAgent.h"
#include "Agent.h"

#define TASK_PRIORITY_FACTOR		100000.0

void AddonBuildControlTowerTask::generateNecessaryTasks(Environment* env)
{
	AgentMap starports = env->getFilteredAgents(BWAPI::UnitTypes::Terran_Starport);

	int freeStarports = 0;
	for(AgentMap::iterator i = starports.begin(); i != starports.end(); i++)
	{
		BaseAgent* agent = (BaseAgent*)(*i).second;
		Unit* starport = agent->getUnit();

		if (starport->isLifted()) continue;
		if (starport->getAddon() != NULL) continue;
		if (env->isTaskTarget(starport, ADDON_BUILD_TASK)) continue;

		freeStarports++;
	}
	
	int futurestarports = env->getFilteredTasks(ADDON_CONTROL_TOWER_TASK).size();

	//if (futureComSats >= freeStarports) return;

	while (futurestarports < freeStarports)
	{
		//Broodwar->printf("Generating AddonBuildControlTowerTask task.");
		env->addTask(new AddonBuildControlTowerTask(env));

		env->generateValidPositions();
		futurestarports++;
	}
}

AddonBuildControlTowerTask::AddonBuildControlTowerTask(Environment* env) : AddonBuildTask(UnitTypes::Terran_Control_Tower, env)
{
	_types.insert(ADDON_CONTROL_TOWER_TASK);
}

AddonBuildControlTowerTask::~AddonBuildControlTowerTask(void)
{
}

void AddonBuildControlTowerTask::calculatePriority()
{
	double prePriority = TASK_PRIORITY_FACTOR;

	_priority = scalePriority(prePriority, MAX_BUILD_PRIORITY, MIN_BUILD_PRIORITY);
}