#include "AddonBuildComSatTask.h"
#include "Environment.h"
#include "BaseAgent.h"
#include "Agent.h"

#define TASK_PRIORITY_FACTOR		100000.0

void AddonBuildComSatTask::generateNecessaryTasks(Environment* env)
{
	UnitTypeCountMap requiredUnits = UnitTypes::Terran_Comsat_Station.requiredUnits();

	for (UnitTypeCountMap::iterator i = requiredUnits.begin(); i != requiredUnits.end(); i++)
	{
		if (env->getFilteredAgents((*i).first).size() == 0) return;
	}

	AgentMap bases = env->getFilteredAgents(BASE_AGENT);

	int freeBases = 0;
	for(AgentMap::iterator i = bases.begin(); i != bases.end(); i++)
	{
		BaseAgent* base = (BaseAgent*)(*i).second;
		Unit* baseUnit = base->getUnit();

		if (baseUnit->isLifted()) continue;
		if (baseUnit->getAddon() != NULL) continue;
		if (env->isTaskTarget(baseUnit, ADDON_BUILD_TASK)) continue;

		freeBases++;
	}
	
	int futureComSats = env->getFilteredTasks(ADDON_BUILD_COMSAT_TASK).size();

	//if (futureComSats >= freeBases) return;

	while (futureComSats < freeBases)
	{
		//Broodwar->printf("Generating AddonBuildComSatTask task.");
		env->addTask(new AddonBuildComSatTask(env));

		env->generateValidPositions();
		futureComSats++;
	}
}

AddonBuildComSatTask::AddonBuildComSatTask(Environment* env) : AddonBuildTask(UnitTypes::Terran_Comsat_Station, env)
{
	_types.insert(ADDON_BUILD_COMSAT_TASK);
}

AddonBuildComSatTask::~AddonBuildComSatTask(void)
{
}

void AddonBuildComSatTask::calculatePriority()
{
	double prePriority = TASK_PRIORITY_FACTOR;

	_priority = scalePriority(prePriority, MAX_BUILD_PRIORITY, MIN_BUILD_PRIORITY);
}