#pragma once

#include "defines.h"

#define MINERAL_SECTOR_VALUE		1
#define GEYSER_SECTOR_VALUE			0
#define BASE_SECTOR_VALUE			20
#define NOT_EXPLORED_SECTOR_VALUE	50

class MapSector
{
protected:
	TilePosition _position;
	TilePosition _centerPosition;

	int _posX, _posY;

	int _sectorWidth;
	int _sectorHeight;

	int _lastVisible;

	TilePositionMap _positions;
	TilePositionMap _walkablePositions;
	TilePositionMap _notVisibleWalkablePositions;

	UnitMemorySet _unitMemories;
	UnitMemorySet _minerals;
	UnitMemorySet _geysers;
	UnitMemorySet _enemies;

	AgentSet _agents;

	bool hasUndetecteds;

	double _resourceValue;
	double _enemyValue;
	double _possibleEnemyValue;

	double _airValuePercentage;
	double _undetectedValuePercentage;

	double _walkablePercentage;
	double _visibilityPercentage;

	int _buildingCount;

	int _deathCount;

	ExploreSectorTask* _exploreSectorTask;

	int _assaultSectorTaskCount;

	void refreshResources();
	void refreshEnemies();
	void refreshBuildingCount();

	Environment* _env;

public:
	MapSector(TilePosition position, Environment* env);
	MapSector(int x, int y, Environment* env);
	virtual ~MapSector();

	void initialize();
	void refresh();

	Environment* getEnvironment();

	void calculateResourceValue();
	double getResourceValue();

	void calculateEnemyValue();
	double getEnemyValue();

	void incPossibleEnemyValue();
	void resetPossibleEnemyValue();

	int getBuildingCount();

	void incDeathCount();
	int getDeathCount();

	void addUnitMemory(UnitMemory* memory);
	void removeUnitMemory(UnitMemory* memory);

	UnitMemorySet* getEnemies();

	void addAgent(Agent* agent);
	void removeAgent(Agent* agent);

	UnitMemorySet* getMinerals();

	AgentSet* getAgents();
	
	double getAirValuePercentage();
	double getUndetectedValuePercentage();

	int getLastVisible();
	int getTimeNotVisible();

	double getWalkablePercentage();
	double getVisibilityPercentage();

	TilePositionMap* getPositions();
	TilePositionMap* getWalkablePositions();
	TilePositionMap* getNotVisibleWalkablePositions();

	TilePosition getCenterPosition();
	TilePosition getPosition();

	bool isWalkableFromStart();
	double getDistanceFromStart();
	double getCornerDistance();

	double getDistance(Position pos);
	double getDistance(TilePosition pos);

	void markExplored();

	void setExploreSectorTask(ExploreSectorTask* task);
	ExploreSectorTask* getExploreSectorTask();

	void incAssaultSectorTaskCount();
	void decAssaultSectorTaskCount();
	int getAssaultSectorTaskCount();

	bool isInSector(Unit* unit);
	bool isInSector(Position pos);
	bool isInSector(TilePosition pos);
};
