#pragma once
#include <BWAPI.h>

#include <BWTA.h>
#include <windows.h>

#include "AiLogger.h"
#include "Environment.h"
#include "Adjuntant.h"

//extern bool analyzed;
//extern bool analysis_just_finished;
//extern BWTA::Region* home;
//extern BWTA::Region* enemy_base;
//DWORD WINAPI AnalyzeThread();

class CromulentAIModule : public BWAPI::AIModule
{
	Environment *_environment;
	Adjuntant *_adjuntant;
	AiLogger* _logger;
	TimerCollector* _timerCollector;

public:
	//BWAPI::AIModule overloads
	virtual void onStart();
	virtual void onEnd(bool isWinner);
	virtual void onFrame();
	virtual void onSendText(std::string text);
	virtual void onReceiveText(BWAPI::Player* player, std::string text);
	virtual void onPlayerLeft(BWAPI::Player* player);
	virtual void onNukeDetect(BWAPI::Position target);
	virtual void onUnitDiscover(BWAPI::Unit* unit);
	virtual void onUnitEvade(BWAPI::Unit* unit);
	virtual void onUnitShow(BWAPI::Unit* unit);
	virtual void onUnitHide(BWAPI::Unit* unit);
	virtual void onUnitCreate(BWAPI::Unit* unit);
	virtual void onUnitDestroy(BWAPI::Unit* unit);
	virtual void onUnitMorph(BWAPI::Unit* unit);
	virtual void onUnitRenegade(BWAPI::Unit* unit);
	virtual void onSaveGame(std::string gameName);

	//CromulentAI functions
	//void drawEnvironmentData();

	//ExampleAI functions
	void drawStats();
	void drawBullets();
	void drawVisibilityData();
	//void drawTerrainData();
	void showPlayers();
	void showForces();
	bool show_bullets;
	bool show_visibility_data;
};
