#pragma once

#include <stdio.h>
#include <time.h>
#include <string>
#include <map>

using namespace std;

class AiLogger
{
	FILE* _logFile;

	bool _disabled;

public:
	AiLogger(const char* filename, bool disabled = false);
	virtual ~AiLogger(void);

	void Log(const char* text);
};

struct Timer
{
	clock_t startTime;
	clock_t checkTime;
	clock_t timespan;
	clock_t longestTimespan;

	Timer() : longestTimespan(0) {}

	void start();
	void check();
};

typedef map<string, Timer*> TimerMap;

class TimerCollector
{
	AiLogger* _logger;
	TimerMap _timers;

public:
	TimerCollector(AiLogger* logger);
	~TimerCollector();

	Timer* StartTimer(string timerId);
	Timer* CheckTimer(string timerId);
};
