#include "AiLogger.h"

AiLogger::AiLogger(const char* filename, bool disabled)
{
	struct tm timeinfo;
	time_t seconds;

	seconds = time(NULL);
	localtime_s(&timeinfo, &seconds);

	char filenametime[100];

	sprintf_s(filenametime, 100, "%s_%d_%d_%d_%d_%d.log", filename, timeinfo.tm_mon, timeinfo.tm_mday, timeinfo.tm_year, timeinfo.tm_hour, timeinfo.tm_min);

	if (!disabled) fopen_s(&_logFile, filenametime, "w");

	_disabled = disabled;
}

AiLogger::~AiLogger(void)
{
	if (!_disabled) fclose(_logFile);
}

void AiLogger::Log(const char* text)
{
	struct tm timeinfo;
	time_t seconds;

	seconds = time(NULL);
	localtime_s(&timeinfo, &seconds);

	if (!_disabled) fprintf(_logFile, "%02d:%02d:%02d -- %s\n", timeinfo.tm_hour, timeinfo.tm_min, timeinfo.tm_sec, text);
}

//////////////////////////////////////////////////////////////////////////

void Timer::start()
{
	startTime = clock();
	timespan = 0;
}

void Timer::check()
{
	checkTime = clock();
	timespan = checkTime - startTime;

	if (longestTimespan < timespan) longestTimespan = timespan;
}

//////////////////////////////////////////////////////////////////////////

TimerCollector::TimerCollector(AiLogger* logger)
{
	_logger = logger;
}

TimerCollector::~TimerCollector()
{
	for(TimerMap::iterator i = _timers.begin(); i != _timers.end(); i++)
	{
		string id = (*i).first;
		Timer* timer = (*i).second;

		if (_logger != NULL)
		{
			char log[100];

			sprintf_s(log, 100, "%s - longest timespan: %.03f milliseconds", id.c_str(), 1000*timer->longestTimespan/(double)CLOCKS_PER_SEC);

			_logger->Log(log);
		}

		delete timer;
	}
}

Timer* TimerCollector::StartTimer(string timerId)
{
	TimerMap::iterator it = _timers.find(timerId);
	Timer* timer = NULL;

	if (it == _timers.end())
	{
		timer = new Timer();
		_timers[timerId] = timer;
	}
	else
	{
		timer = (*it).second;
	}

	timer->start();

	return timer;
}

Timer* TimerCollector::CheckTimer(string timerId)
{
	TimerMap::iterator it = _timers.find(timerId);

	if (it == _timers.end()) return NULL;

	Timer* timer = (*it).second;

	timer->check();

	return timer;
}
