#include "WorkerAgent.h"
#include "BaseAgent.h"
#include "Environment.h"
#include "BuildTask.h"
#include "RecollectMinTask.h"
#include "RecollectGasTask.h"

WorkerAgent::WorkerAgent(Unit* unit, Environment* env) : AttackerAgent(unit, env)
{
	_types.insert(WORKER_AGENT);
}

WorkerAgent::~WorkerAgent(void)
{
}

void WorkerAgent::executeUnitBehavior()
{
	AttackerAgent::executeUnitBehavior();

	if (!_canDoSomethingElse) return;

	dropResourcesIfNecessary();
}

void WorkerAgent::dropResourcesIfNecessary()
{
	if (!_unit->isCarryingGas() && !_unit->isCarryingMinerals()) return;

	if (_unit->isCarryingGas() && (_currentTask != NULL) && isCurrentTaskType(RECOLLECT_GAS_TASK)) return;
	if (_unit->isCarryingMinerals() && (_currentTask != NULL) && isCurrentTaskType(RECOLLECT_MIN_TASK)) return;

	Unit* target = _unit->getTarget();

	if (!_unit->isRepairing() &&
		!_unit->isAttacking() &&
		(target != NULL) &&
		(target->getType() == UnitTypes::Terran_Command_Center))
	{
		_canDoSomethingElse = false;
		return;
	}

	AgentMap bases = _env->getFilteredAgents(BASE_AGENT);

	BaseAgent* closestBase = NULL;
	double closestDist = MAX_POS_DISTANCE;

	for(AgentMap::iterator i = bases.begin(); i != bases.end(); i++)
	{
		BaseAgent* base = (BaseAgent*)(*i).second;

		Position basePos = base->getUnit()->getPosition();

		if (!_unit->hasPath(basePos)) continue;

		double distance = _unit->getDistance(basePos);

		if (distance >= closestDist) continue;

		closestDist = distance;
		closestBase = base;
	}

	if (closestBase == NULL) return;

	_unit->rightClick(closestBase->getUnit());

	_canDoSomethingElse = false;
}

void WorkerAgent::displayInfo(int &row)
{
	AttackerAgent::displayInfo(row);

	if (isCurrentTaskType(BUILD_TASK))
	{
		BuildTask* buildTask = (BuildTask*)_currentTask;

		UnitType buildingType = buildTask->getBuildingType();

		int width = buildingType.tileWidth();
		int height = buildingType.tileHeight();

		Position bPos = Position(buildTask->getBuildingPosition());
		Position uPos = _unit->getPosition();
		
		int uRadius = _unit->getType().dimensionRight();

		//draw circle around unit
		Broodwar->drawCircle(CoordinateType::Map, uPos.x(), uPos.y(), uRadius, Colors::Yellow, false);

		//draw line to building position
		Broodwar->drawLine(CoordinateType::Map, uPos.x(), uPos.y(), bPos.x(), bPos.y(), Colors::Yellow);

		//draw outline of building to be placed
		Broodwar->drawBox(CoordinateType::Map, bPos.x(), bPos.y(), bPos.x() + width*32, bPos.y() + height*32, Colors::Yellow, false);
	}
	else if (isCurrentTaskType(RECOLLECT_MIN_TASK))
	{
		RecollectMinTask* recMinTask = (RecollectMinTask*)_currentTask;

		Unit* resource = recMinTask->getResource();

		Position rPos = resource->getPosition();
		Position uPos = _unit->getPosition();

		int uRadius = _unit->getType().dimensionRight();
		int rRadius = resource->getType().dimensionRight();

		//draw circle around unit
		Broodwar->drawCircle(CoordinateType::Map, uPos.x(), uPos.y(), uRadius, Colors::Teal, false);

		//draw line to building position
		Broodwar->drawLine(CoordinateType::Map, uPos.x(), uPos.y(), rPos.x(), rPos.y(), Colors::Teal);

		//draw circle around resource
		Broodwar->drawCircle(CoordinateType::Map, rPos.x(), rPos.y(), rRadius, Colors::Teal, false);
	}
	else if (isCurrentTaskType(RECOLLECT_GAS_TASK))
	{
		RecollectGasTask* recGasTask = (RecollectGasTask*)_currentTask;

		Unit* resource = recGasTask->getResource();

		Position rPos = resource->getPosition();
		Position uPos = _unit->getPosition();

		int uRadius = _unit->getType().dimensionRight();
		int rRadius = resource->getType().dimensionRight();

		//draw circle around unit
		Broodwar->drawCircle(CoordinateType::Map, uPos.x(), uPos.y(), uRadius, Colors::Teal, false);

		//draw line to building position
		Broodwar->drawLine(CoordinateType::Map, uPos.x(), uPos.y(), rPos.x(), rPos.y(), Colors::Teal);

		//draw circle around resource
		Broodwar->drawCircle(CoordinateType::Map, rPos.x(), rPos.y(), rRadius, Colors::Teal, false);
	}
}
