#include "ExploreSectorTask.h"
#include "MapSector.h"
#include "ExplorerAgent.h"
#include "Environment.h"

ExplorerAgent::ExplorerAgent(Unit* unit, Environment* env) : Agent(unit, env)
{
	_types.insert(EXPLORER_AGENT);
}

ExplorerAgent::~ExplorerAgent(void)
{
}

void ExplorerAgent::executeUnitBehavior()
{
	Agent::executeUnitBehavior();

	if (!_canDoSomethingElse) return;

	abandonTaskIfDangerous();
	//abandonTaskIfStuck();
}

void ExplorerAgent::abandonTaskIfStuck()
{
	//if (_unit->isAttacking()) return;

	if (!_unit->isStuck()) return;

	assignTask(NULL);

	_canDoSomethingElse = false;
}

void ExplorerAgent::abandonTaskIfDangerous()
{
	if (_unit->isUnderAttack())
	{
		//Quadrant* quadrant = _env->getQuadrant(_unit->getTilePosition());
		//quadrant->dangerous = true;

		if (_currentTask != NULL)
		{
			if (isCurrentTaskType(EXPLORE_SECTOR_TASK))
			{
				ExploreSectorTask* task = (ExploreSectorTask*)_currentTask;

				Quadrant* taskQuadrant = _env->getQuadrant(task->getSector());
				taskQuadrant->visited = true;
			}

			if (_disposition == COWARD) assignTask(NULL);
		}
		
		if (_disposition == COWARD)
		{
			Agent* base = _env->getClosestAgent(BASE_AGENT, _unit->getPosition());

			if (base != NULL)
			{
				Unit* baseUnit = base->getUnit();

				if (_unit->getOrderTarget() != baseUnit)
				{
					_unit->rightClick(baseUnit);
				}
			}

			_canDoSomethingElse = false;
		}
	}
}

void ExplorerAgent::displayInfo(int &row)
{
	Agent::displayInfo(row);

	if (isCurrentTaskType(EXPLORE_SECTOR_TASK))
	{
		ExploreSectorTask* task = (ExploreSectorTask*)_currentTask;

		MapSector* sector = task->getSector();

		TilePosition ctPos = sector->getCenterPosition();
		Position bPos = Position(ctPos);
		Position coPos = Position(sector->getPosition());
		Position uPos = _unit->getPosition();
		
		int uRadius = _unit->getType().dimensionRight();

		Color color = Colors::Green;

		//draw circle around unit
		Broodwar->drawCircle(CoordinateType::Map, uPos.x(), uPos.y(), uRadius, color, false);

		//draw line to building position
		Broodwar->drawLine(CoordinateType::Map, uPos.x(), uPos.y(), bPos.x(), bPos.y(), color);
		
		TilePosition tPos = sector->getPosition();
		Position aPos(tPos);

		// Mark center of sector
		if (ctPos != TilePositions::None)
		{
			Position cPos(ctPos);

			Broodwar->drawBox(
				CoordinateType::Map,
				cPos.x() - 5, cPos.y() - 5,
				cPos.x() + 5, cPos.y() + 5,
				color, true);
		}

		// Draw outline of sector
		Broodwar->drawBox(
			CoordinateType::Map,
			coPos.x(), coPos.y(),
			coPos.x() + SECTOR_LENGTH_IN_PIXELS, coPos.y() + SECTOR_LENGTH_IN_PIXELS,
			color, false);
	}
}

