#pragma once

#include "BuildingAgent.h"

class BaseAgent :
	public BuildingAgent
{
protected:
	UnitSet _mineralPatches;
	UnitSet _refineries;
	UnitSet _geysers;

	UnitType _refineryType;

public:
	BaseAgent(Unit* unit, Environment* env);
	virtual ~BaseAgent(void);

	void initialize();
	void refresh();

	UnitSet* getMineralPatches();
	UnitSet* getRefineries();
	UnitSet* getGeysers();

	void displayInfo(int &row);
};
