#include "BaseAgent.h"
#include "Environment.h"
#include "RecollectMinTask.h"
#include "RecollectGasTask.h"
#include "TrainWorkerTask.h"

BaseAgent::BaseAgent(Unit* unit, Environment* env) : BuildingAgent(unit, env)
{
	Position basePos = unit->getPosition();

	_types.insert(BASE_AGENT);

	_refineryType = _env->getPlayer()->getRace().getRefinery();
}

void BaseAgent::refresh()
{
	_mineralPatches.clear();
	_refineries.clear();
	_geysers.clear();

	if (_unit->isLifted()) return;

	UnitSet patches = Broodwar->getMinerals();

	for(UnitSet::iterator m = patches.begin(); m != patches.end(); m++)
	{
		Unit* patch = (*m);

		if ((patch->getDistance(_unit) < MAX_RESOURCE_RANGE) && patch->exists())
		//if ((patch->getDistance(_unit) < MAX_RESOURCE_RANGE) && (patch->getResources() > 0))
		{
			_mineralPatches.insert(patch);
		}
	}

	UnitSet geysers = Broodwar->getGeysers();

	for(UnitSet::iterator m = geysers.begin(); m != geysers.end(); m++)
	{
		Unit* geyser = (*m);

		if ((geyser->getDistance(_unit) < MAX_RESOURCE_RANGE) && (geyser->getType() == UnitTypes::Resource_Vespene_Geyser))
		{
			_geysers.insert(geyser);
		}
	}

	AgentMap refineries = _env->getFilteredAgents(_refineryType);

	for(AgentMap::iterator m = refineries.begin(); m != refineries.end(); m++)
	{
		Unit* refinery = (*m).second->getUnit();

		if (refinery->getDistance(_unit) < MAX_RESOURCE_RANGE)
		{
			_refineries.insert(refinery);
		}
	}
}

BaseAgent::~BaseAgent(void)
{
}

void BaseAgent::initialize()
{
	refresh();
}

UnitSet* BaseAgent::getMineralPatches()
{
	return &_mineralPatches;
}

UnitSet* BaseAgent::getRefineries()
{
	return &_refineries;
}

UnitSet* BaseAgent::getGeysers()
{
	return &_geysers;
}

void BaseAgent::displayInfo(int &row)
{
	Agent::displayInfo(row);

	if (!_unit->isSelected()) return;

	TilePosition p = _unit->getTilePosition();
	Position basePos = _unit->getPosition();

	UnitType baseType = _unit->getType();

	int width = baseType.tileWidth();
	int height = baseType.tileHeight();

	//draw outline of base
	Broodwar->drawBox(CoordinateType::Map, p.x()*32, p.y()*32, (p.x() + width)*32, (p.y() + height)*32, Colors::Blue, false);

	//draw max reach cicle
	Broodwar->drawCircle(CoordinateType::Map, basePos.x(), basePos.y(), MAX_RESOURCE_RANGE, Colors::Blue, false);

	if (_unit->isLifted()) return;

	width = UnitTypes::Resource_Mineral_Field.tileWidth();
	
	//Iterate through all mineral patches close to player base.
	for(UnitSet::const_iterator i = _mineralPatches.begin(); i != _mineralPatches.end(); i++)
	{
		Unit* patch = (*i);

		TilePosition p = patch->getTilePosition();
		Position c = patch->getPosition();

		//draw circle around patch
		Broodwar->drawCircle(CoordinateType::Map, c.x(), c.y(), width/2, Colors::Cyan, false);
	}

	width = UnitTypes::Resource_Vespene_Geyser.tileWidth();
	
	//Iterate through all geysers close to player base.
	for(UnitSet::const_iterator i = _geysers.begin(); i != _geysers.end(); i++)
	{
		Unit* geyser = (*i);

		TilePosition p = geyser->getTilePosition();
		Position c = geyser->getPosition();

		//draw circle around patch
		Broodwar->drawCircle(CoordinateType::Map, c.x(), c.y(), width/2, Colors::Cyan, false);
	}

	////Draw Valid TilePositions
	//for(TilePositionMap::const_iterator i = _validPositions.begin(); i != _validPositions.end(); i++)
	//{
	//	TilePosition tPos = (*i).second;
	//	Position pos(tPos);

	//	Broodwar->drawDot(CoordinateType::Map, pos.x(), pos.y(), Colors::Red);
	//	Broodwar->drawDot(CoordinateType::Map, pos.x() + 1, pos.y() + 1, Colors::Red);
	//	Broodwar->drawDot(CoordinateType::Map, pos.x(), pos.y() + 1, Colors::Red);
	//	Broodwar->drawDot(CoordinateType::Map, pos.x() + 1, pos.y(), Colors::Red);
	//}
}

