#pragma once

#include "defines.h"

class Agent
{
protected:
	Unit* _unit;
	Task* _currentTask;
	Environment* _env;

	int _taskHeldFrames;
	int _taskActionFrame;

	AgentTypeSet _types;

	AgentDisposition _disposition;

	double _currentAptitude;

	bool _canDoSomethingElse;

	ProtectUnitTask* _protectUnitTask;

	Position _targetPosition;
	Position _lastPosition;
	MapSector* _sector;

	double _tempValue;

public:
	static Agent* createAgent(Unit* unit, Environment* env);

	static AgentMap filterMap(AgentMap* agents, AgentType type, bool finished = true);
	static AgentMap filterMap(AgentMap* agents, UnitType type, bool finished = true);
	static AgentMap filterMap(AgentMap* agents, TaskType type, bool finished = true);
	
	static Agent* closestAgent(AgentMap* agents, AgentType type, Position pos);
	static Agent* closestAgent(AgentMap* agents, UnitType type, Position pos);
	static Agent* closestAgent(AgentMap* agents, TaskType type, Position pos);

	Agent(Unit* unit, Environment* env);
	virtual ~Agent(void);

	bool isType(AgentType);

	virtual void initialize();
	virtual void refresh();

	Unit* getUnit();
	UnitType getUnitType();
	Position getUnitPosition();

	Position getTargetPosition();
	void setTargetPosition(Position pos);

	bool canAttackAir();
	bool canAttackGround();

	int getAirWeaponDamage();
	int getGroundWeaponDamage();

	int getAirWeaponRange();
	int getGroundWeaponRange();

	ProtectUnitTask* getProtectUnitTask();
	void setProtectUnitTask(ProtectUnitTask* task);

	UnitSet getEnemiesInRange(int range);
	UnitSet getEnemiesInRangeAirAttack();
	UnitSet getEnemiesInRangeGroundAttack(bool sieged = false);
	
	Unit* getBestTargetInRange(int range, bool ignoreUnarmed = true);
	Unit* getBestTargetInAttackRange(bool ignoreUnarmed = true, bool sieged = false);

	void assignTask(Task* task);
	//void removeDeletedTask();
	Task* getCurrentTask();
	bool isCurrentTaskType(TaskType type);

	int getTaskHeldTime();

	bool isFinished();

	void step();
	virtual void executeUnitBehavior();

	void setDisposition(AgentDisposition disposition);
	AgentDisposition getDisposition();

	void setCurrentAptitude(double aptitude);
	double getCurrentAptitude();

	void setTempValue(double value);
	double getTempValue();

	void setSector(MapSector* sector);
	MapSector* getSector();

	virtual void cleanup();

	virtual void displayInfo(int &row);
};
