#pragma once

#include "defines.h"
#include "AiLogger.h"

class Adjuntant
{
	Environment* _env;

	AiLogger* _logger;
	TimerCollector* _timerCollector;

	bool _willBuildSupply;

	TaskList prioritizeTasks();

	void assignTasksToAgents(TaskList* tasks);
	void evaluateStatus(TaskList* tasks);

	void generateNecessaryTasks();
	void removeFinishedTasks();

	void stepAgents();

public:
	Adjuntant(Environment* env, AiLogger* logger);
	virtual ~Adjuntant(void);

	void displayInfo();
	void displayPlannedBuildings();
	void displayTaskInfo(int &row, Agent* agent);
	Agent* displayAgentInfo(int &row);
	void displayMapSectors();
	
	TaskList createSortedTaskList();

	void process();
};
