#include "VultureAgent.h"
#include "PFManager.h"
#include "AgentManager.h"
#include "Commander.h"

VultureAgent::VultureAgent(Unit* mUnit) {
	unit = mUnit;
	unitID = unit->getID();
	//Broodwar->printf("VultureAgent created (%s)", unit->getType().getName().c_str());
	mineDropFrame = 0;

	goal = TilePosition(-1, -1);
}

void VultureAgent::computeActions() {
	Squad* sq = Commander::getInstance()->getSquad(squadID);
	if (sq != NULL) {
		if (sq->isKite()) {
			computeKitingActions();
			return;
		}
	}

	int eCnt = enemyGroundAttackingUnitsWithinRange(unit->getTilePosition(), 320);
	if (eCnt > 0) {
		int framesSinceDrop = Broodwar->getFrameCount() - mineDropFrame;
		if (unit->getSpiderMineCount() > 0 && framesSinceDrop >= 100) {
			//Broodwar->printf("[%d] dropped spider mine", unitID);
			unit->useTech(TechTypes::Spider_Mines, unit->getPosition());
			mineDropFrame = Broodwar->getFrameCount();
			return;
		}
	}

	PFManager::getInstance()->computeAttackingUnitActions(this, goal, false);
}

string VultureAgent::getTypeName() {
	return "VultureAgent";
}

