#include "ValkyrieAgent.h"
#include "PFManager.h"
#include "AgentManager.h"
#include "Commander.h"

ValkyrieAgent::ValkyrieAgent(Unit* mUnit) {
	unit = mUnit;
	unitID = unit->getID();
	//Broodwar->printf("ValkyrieAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
}

void ValkyrieAgent::computeActions() {
	Squad* sq = Commander::getInstance()->getSquad(squadID);
	if (sq != NULL) {
		if (sq->isKite()) {
			computeKitingActions();
			return;
		}
	}

	bool defensive = useDefensiveMode();
	PFManager::getInstance()->computeAttackingUnitActions(this, goal, defensive);
}

string ValkyrieAgent::getTypeName() {
	return "ValkyrieAgent";
}
