#include "UpgradesFileReader.h"
#include "ExplorationManager.h"
#include "BuildPlanner.h"
#include <fstream>
#include <sstream>

UpgradesFileReader::UpgradesFileReader() {

}

bool UpgradesFileReader::fileExists(string filename) {
	ifstream inFile;

	stringstream ss;
	ss << "bwapi-data\\AI\\BTHAI-data\\upgrades\\";
	ss << filename;
	string filePath = ss.str();

	inFile.open(filePath.c_str());

	if (!inFile) {
		return false;
	}
	else {
		inFile.close();
		return true;
	}
}

string UpgradesFileReader::getFilename() {
	string filename = "";

	if (BuildPlanner::isProtoss()) {
		if (ExplorationManager::enemyIsProtoss()) {
			filename = "PvP.txt";
			if (!fileExists(filename)) filename = "PvX.txt";
		}
		else if (ExplorationManager::enemyIsTerran()) {
			filename = "PvT.txt";
			if (!fileExists(filename)) filename = "PvX.txt";
		}
		else if (ExplorationManager::enemyIsZerg()) {
			filename = "PvZ.txt";
			if (!fileExists(filename)) filename = "PvX.txt";
		}
	}
	else if (BuildPlanner::isTerran()) {
		if (ExplorationManager::enemyIsProtoss()) {
			filename = "TvP.txt";
			if (!fileExists(filename)) filename = "TvX.txt";
		}
		else if (ExplorationManager::enemyIsTerran()) {
			filename = "TvT.txt";
			if (!fileExists(filename)) filename = "TvX.txt";
		}
		else if (ExplorationManager::enemyIsZerg()) {
			filename = "TvZ.txt";
			if (!fileExists(filename)) filename = "TvX.txt";
		}
	}
	else if (BuildPlanner::isZerg()) {
		if (ExplorationManager::enemyIsProtoss()) {
			filename = "ZvP.txt";
			if (!fileExists(filename)) filename = "ZvX.txt";
		}
		else if (ExplorationManager::enemyIsTerran()) {
			filename = "ZvT.txt";
			if (!fileExists(filename)) filename = "ZvX.txt";
		}
		else if (ExplorationManager::enemyIsZerg()) {
			filename = "ZvZ.txt";
			if (!fileExists(filename)) filename = "ZvX.txt";
		}
	}

	return filename;
}

vector<UpgradeType> UpgradesFileReader::getUpgradesP1() {
	return upgradesP1;
}

vector<UpgradeType> UpgradesFileReader::getUpgradesP2() {
	return upgradesP2;
}

vector<UpgradeType> UpgradesFileReader::getUpgradesP3() {
	return upgradesP3;
}

vector<TechType> UpgradesFileReader::getTechsP1() {
	return techsP1;
}

vector<TechType> UpgradesFileReader::getTechsP2() {
	return techsP2;
}

vector<TechType> UpgradesFileReader::getTechsP3() {
	return techsP3;
}

void UpgradesFileReader::readUpgrades() {
	string filename = getFilename();
	
	ifstream inFile;

	stringstream ss;
	ss << "bwapi-data\\AI\\BTHAI-data\\upgrades\\";
	ss << filename;
	string filePath = ss.str();

	inFile.open(filePath.c_str());

	if (!inFile) {
		Broodwar->printf("Unable to open file %s", filePath.c_str());
	}
	else {
		string line;
		char buffer[256];
		while (!inFile.eof()) {
			inFile.getline(buffer, 100);
			if (buffer[0] != ';') {
				stringstream ss;
				ss << buffer;
				line = ss.str();
				addUpgrade(line);
			}
		}
		inFile.close();
	}

	Broodwar->printf("Upgrades file %s loaded", filePath.c_str());
}

void UpgradesFileReader::addUpgrade(string line) {
	if (line == "") return;

	//Replace all _ with whitespaces, or they wont match
	replace(line);
	Tokens tokens = split(line, ":");
	
	for(set<UpgradeType>::iterator i=UpgradeTypes::allUpgradeTypes().begin();i!=UpgradeTypes::allUpgradeTypes().end();i++) {
		if ((*i).getName() == tokens.key) {
			int value = toInt(tokens.value);
			if (value == 1) upgradesP1.push_back((*i));
			if (value == 2) upgradesP2.push_back((*i));
			if (value == 3) upgradesP2.push_back((*i));
			return;
		}
	}

	for(set<TechType>::iterator i=TechTypes::allTechTypes().begin();i!=TechTypes::allTechTypes().end();i++) {
		if ((*i).getName() == tokens.key) {
			int value = toInt(tokens.value);
			if (value == 1) techsP1.push_back((*i));
			if (value == 2) techsP1.push_back((*i));
			if (value == 3) techsP1.push_back((*i));
			return;
		}
	}

	//No match found
	Broodwar->printf("Error: No matching upgrade or tech found for %s", line.c_str());
}

void UpgradesFileReader::replace(string &line) {
	int usIndex = line.find("_");
	while (usIndex != string::npos) {
		line.replace(usIndex, 1, " ");
		usIndex = line.find("_");
	}
}

Tokens UpgradesFileReader::split(string line, string delimiter) {
	Tokens tokens;
	tokens.key = "";
	tokens.value = "";

	int eqIndex = line.find(delimiter);
	if (eqIndex != string::npos) {
		tokens.key = line.substr(0, eqIndex);
		tokens.value = line.substr(eqIndex + 1, line.length());
	}
	return tokens;
}

int UpgradesFileReader::toInt(string &str) {
	stringstream ss(str);
	int n;
	ss >> n;
	return n;
}
