#include "TargetingAgent.h"

Unit* TargetingAgent::findTarget(BaseAgent* agent) {
	int gRange = agent->getUnitType().groundWeapon().maxRange();
	int aRange = agent->getUnitType().airWeapon().maxRange();

	int bestTargetScore = -1;
	Unit* target = NULL;

	for(set<Unit*>::const_iterator i=Broodwar->enemy()->getUnits().begin();i!=Broodwar->enemy()->getUnits().end();i++) {
		UnitType t = (*i)->getType();
		double d = agent->getUnit()->getDistance((*i));

		int cScore = t.destroyScore();
		if (t.canAttack()) cScore = (int)(cScore * 1.5);

		if (t.isFlyer() && d <= aRange) {
			if (cScore > bestTargetScore) {
				bestTargetScore = cScore;
				target = (*i);
			}
		}
		if (t.isFlyingBuilding() && (*i)->isLifted() && d <= aRange) {
			//Skip if we have other targets
		}
		if (t.isFlyingBuilding() && !(*i)->isLifted() && d <= aRange) {
			if (cScore > bestTargetScore) {
				bestTargetScore = cScore;
				target = (*i);
			}
		}
		if (!t.isFlyer() && d <= gRange) {
			if (cScore > bestTargetScore) {
				bestTargetScore = cScore;
				target = (*i);
			}
		}
	}

	return target;
}