#ifndef __SQUADFILEREADER_H__
#define __SQUADFILEREADER_H__

#include <BWAPI.h>
#include "Squad.h"

using namespace BWAPI;
using namespace std;

struct Tokens {
	string key;
	string value;
};

/** This class reads the squad setup script files.
 *
 * Author: Johan Hagelback (johan.hagelback@gmail.com)
 */
class SquadFileReader {

private:
	bool fileExists(string filename);
	string getFilename();
	void addSquad(string line, vector<UnitType> &squads);
	void replace(string &line);
	Tokens split(string line, string delimiter);
	int toInt(string &str);
	void addUnit(string line);
	void createSquad();

	string type;
	string move;
	string name;
	string offType;
	string requirement;
	int priority;
	int activePriority;

	Squad* cSquad;
	int id;

	vector<Squad*> squads;

public:
	/** Constructor. */
	SquadFileReader();

	/** Reads the squad setup script file. */
	vector<Squad*> readSquadList();
};

#endif