#include "SquadFileReader.h"
#include "ExplorationManager.h"
#include "BuildPlanner.h"
#include "HarassSquad.h"
#include "RushSquad.h"
#include "KiteSquad.h"
#include "ShuttleSquad.h"
#include "ChokeHarassSquad.h"
#include "ExplorationSquad.h"
#include <fstream>
#include <sstream>

SquadFileReader::SquadFileReader() {
	id = 1;
}

bool SquadFileReader::fileExists(string filename) {
	ifstream inFile;

	stringstream ss;
	ss << "bwapi-data\\AI\\BTHAI-data\\squads\\";
	ss << filename;
	string filePath = ss.str();

	inFile.open(filePath.c_str());

	if (!inFile) {
		return false;
	}
	else {
		inFile.close();
		return true;
	}
}

string SquadFileReader::getFilename() {
	string filename = "";

	if (BuildPlanner::isProtoss()) {
		if (ExplorationManager::enemyIsProtoss()) {
			filename = "PvP.txt";
			if (!fileExists(filename)) filename = "PvX.txt";
		}
		else if (ExplorationManager::enemyIsTerran()) {
			filename = "PvT.txt";
			if (!fileExists(filename)) filename = "PvX.txt";
		}
		else if (ExplorationManager::enemyIsZerg()) {
			filename = "PvZ.txt";
			if (!fileExists(filename)) filename = "PvX.txt";
		}
	}
	else if (BuildPlanner::isTerran()) {
		if (ExplorationManager::enemyIsProtoss()) {
			filename = "TvP.txt";
			if (!fileExists(filename)) filename = "TvX.txt";
		}
		else if (ExplorationManager::enemyIsTerran()) {
			filename = "TvT.txt";
			if (!fileExists(filename)) filename = "TvX.txt";
		}
		else if (ExplorationManager::enemyIsZerg()) {
			filename = "TvZ.txt";
			if (!fileExists(filename)) filename = "TvX.txt";
		}
	}
	else if (BuildPlanner::isZerg()) {
		if (ExplorationManager::enemyIsProtoss()) {
			filename = "ZvP.txt";
			if (!fileExists(filename)) filename = "ZvX.txt";
		}
		else if (ExplorationManager::enemyIsTerran()) {
			filename = "ZvT.txt";
			if (!fileExists(filename)) filename = "ZvX.txt";
		}
		else if (ExplorationManager::enemyIsZerg()) {
			filename = "ZvZ.txt";
			if (!fileExists(filename)) filename = "ZvX.txt";
		}
	}
	else {

	}
	return filename;
}

vector<Squad*> SquadFileReader::readSquadList() {
	string filename = getFilename();
	
	//Read buildorder file
	ifstream inFile;

	stringstream ss;
	ss << "bwapi-data\\AI\\BTHAI-data\\squads\\";
	ss << filename;
	string filePath = ss.str();

	inFile.open(filePath.c_str());

	if (!inFile) {
		Broodwar->printf("Unable to open file %s", filePath.c_str());
	}
	else {
		string line;
		char buffer[256];

		while (!inFile.eof()) {
			inFile.getline(buffer, 100);
			if (buffer[0] != ';') {
				stringstream ss;
				ss << buffer;
				line = ss.str();
				
				Tokens token = split(line, "=");
				
				if (token.key == "Type") {
					type = token.value;
				}
				if (token.key == "Move") {
					move = token.value;
				}
				if (token.key == "Name") {
					name = token.value;
				}
				if (token.key == "Priority") {
					priority = toInt(token.value);
					activePriority = priority;
				}
				if (token.key == "ActivePriority") {
					activePriority = toInt(token.value);
				}
				if (token.key == "OffenseType") {
					offType = token.value;
				}
				if (line == "<setup>") {
					createSquad();
				}
				if (token.key == "Unit") {
					addUnit(token.value);
				}
			}
		}
		inFile.close();
	}

	Broodwar->printf("Squad file %s loaded. %d squads added.", filePath.c_str(), (int)squads.size());
	
	return squads;
}

Tokens SquadFileReader::split(string line, string delimiter) {
	Tokens tokens;
	tokens.key = "";
	tokens.value = "";

	int eqIndex = line.find(delimiter);
	if (eqIndex != string::npos) {
		tokens.key = line.substr(0, eqIndex);
		tokens.value = line.substr(eqIndex + 1, line.length());
	}
	return tokens;
}

int SquadFileReader::toInt(string &str) {
	stringstream ss(str);
	int n;
	ss >> n;
	return n;
}

void SquadFileReader::createSquad() {
	int moveType = Squad::GROUND;
	if (move == "AIR" || move == "Air" || move == "air") {
		moveType = Squad::AIR;
	}

	if (type == "Offensive") {
		cSquad = new Squad(id, Squad::OFFENSIVE, moveType, name, priority);
	}
	else if (type == "Offense") {
		cSquad = new Squad(id, Squad::OFFENSIVE, moveType, name, priority);
	}
	else if (type == "Defensive") {
		cSquad = new Squad(id, Squad::DEFENSIVE, moveType, name, priority);
	}
	else if (type == "Defense") {
		cSquad = new Squad(id, Squad::DEFENSIVE, moveType, name, priority);
	}
	else if (type == "Support") {
		cSquad = new Squad(id, Squad::SUPPORT, moveType, name, priority);
	}
	else if (type == "Support") {
		cSquad = new Squad(id, Squad::SUPPORT, moveType, name, priority);
	}
	else if (type == "Exploration") {
		cSquad = new ExplorationSquad(id, name, moveType, priority);
	}
	else if (type == "Rush") {
		cSquad = new RushSquad(id, name, moveType, priority);
	}
	else if (type == "ChokeHarass") {
		cSquad = new ChokeHarassSquad(id, name, moveType, priority);
	}
	else if (type == "Kite") {
		cSquad = new KiteSquad(id, name, moveType, priority);
	}
	else if (type == "Harass") {
		cSquad = new HarassSquad(id, name, priority);
	}
	else if (type == "ShuttleReaver") {
		cSquad = new ShuttleSquad(id, name, priority, false);
	}
	else if (type == "ReaverBaseHarass") {
		cSquad = new ShuttleSquad(id, name, priority, true);
	}
	else {
		Broodwar->printf("Fatal: No Squad type found for entry %s", type.c_str());
		return;
	}

	if (offType == "Required") {
		cSquad->setRequired(true);
	}
	cSquad->setActivePriority(activePriority);
	
	//Broodwar->printf("Added squad: [%d] %s", id, type.c_str());

	squads.push_back(cSquad);
	id++;
}

void SquadFileReader::addUnit(string line) {
	Tokens token = split(line, ":");

	//Replace all _ with whitespaces, or they wont match
	replace(token.key);
	
	for(set<UnitType>::iterator i=UnitTypes::allUnitTypes().begin();i!=UnitTypes::allUnitTypes().end();i++) {
		if ((*i).getName() == token.key) {
			int no = toInt(token.value);
			cSquad->addSetup((*i), toInt(token.value));
			return;
		}
	}

	//No UnitType match found
	Broodwar->printf("Error: No matching UnitType found for %s", token.key.c_str());
}

void SquadFileReader::replace(string &line) {
	int usIndex = line.find("_");
	while (usIndex != string::npos) {
		line.replace(usIndex, 1, " ");
		usIndex = line.find("_");
	}
}
