#include "ShuttleSquad.h"
#include "UnitAgent.h"
#include "ExplorationManager.h"

ShuttleSquad::ShuttleSquad(int mId, string mName, int mPriority, bool mIsBaseHarass) {
	this->id = mId;
	this->type = SHUTTLE;
	this->moveType = AIR;
	this->name = mName;
	this->priority = mPriority;
	this->baseHarass = mIsBaseHarass;
	activePriority = priority;
	active = false;
	required = false;
	init = false;
	goal = TilePosition(-1, -1);
	goalSetFrame = 0;
	state = IDLE;
}

bool ShuttleSquad::isActive() {
	if (active && init) {
		return true;
	}
	return false;
}

void ShuttleSquad::computeActions() {
	if (!active) {
		if (isFull()) {
			active = true;
		}
	}

	if (active && baseHarass) {
		setGoal(TilePosition(-1,-1));
	}

	//First, remove dead agents
	for(int i = 0; i < (int)agents.size(); i++) {
		if(!agents.at(i)->isAlive()) {
			agents.erase(agents.begin() + i);
			i--;
		}
	}

	//1. Find Shuttle Reference
	UnitAgent* shuttleRef = NULL;
	for(int i = 0; i < (int)agents.size(); i++) {
		if(UnitAgent::isOfType(agents[i]->getUnit(), UnitTypes::Protoss_Shuttle)) {
			if (!agents[i]->getUnit()->isBeingConstructed()) {
				shuttleRef = (UnitAgent*)agents[i];
				break;
			}
		}
	}
	if (shuttleRef == NULL) {
		//No Shuttle, nothing to do.
		return;
	}

	state = IDLE;

	//We need to now how many enemy units there are around us
	int eCnt = shuttleRef->enemyGroundUnitsWithinRange(256); //8 tiles?
	
	//2. Check if we need to load Reavers.
	if (eCnt == 0) {
		if (shuttleRef->getUnit()->getLoadedUnits().size() < 2) {
			if ((int)agents.size() > 1) {
				//We have at least one Reaver. See if we shall load it.

				for(int i = 0; i < (int)agents.size(); i++) {
					if(UnitAgent::isOfType(agents[i]->getUnit(), UnitTypes::Protoss_Reaver)) {
						if (agents.at(i)->isAlive() && agents[i]->getUnit()->getScarabCount() > 4 && !agents.at(i)->getUnit()->isLoaded()) {
							//Load the Reaver
							shuttleRef->getUnit()->load(agents.at(i)->getUnit());
							state = BUSY;
							return;
						}
					}
				}
			}
		}
	}

	//3. Check if all units are loaded
	if (!init) {
		if (shuttleRef->getUnit()->getLoadedUnits().size() == 2) {
			init = true;
			Broodwar->printf("Ready at frame %d", Broodwar->getFrameCount());
		}
	}

	//4. Check if we have enemies nearby
	if (eCnt > 0) {
		if (isActive() && shuttleRef->getUnit()->getLoadedUnits().size() > 0) { 
			if (Broodwar->isBuildable(shuttleRef->getUnit()->getTilePosition())) {
				shuttleRef->getUnit()->unloadAll();
				state = BUSY;
				return;
			}
		}
	}

	//5. Check if we shall pick up Reavers due to cooldown
	if (eCnt > 0) {
		for(int i = 0; i < (int)agents.size(); i++) {
			if(UnitAgent::isOfType(agents[i]->getUnit(), UnitTypes::Protoss_Reaver) && !agents.at(i)->getUnit()->isLoaded()) {
				if (agents[i]->getUnit()->getGroundWeaponCooldown() > 30) {
					//Load the Reaver
					shuttleRef->getUnit()->load(agents.at(i)->getUnit());
					state = BUSY;
					return;
				}
			}
		}
	}

	if (active) {
		if (activePriority != priority) {
			priority = activePriority;
		}
	}
}

void ShuttleSquad::printInfo() {
	string f = "NotFull";
	if (isFull()) {
		f = "Full";
	}
	string a = "Inactive";
	if (isActive()) {
		a = "Active";
	}

	Broodwar->printf("[ShuttleSquad %d] %s (%s, %s)", id, name.c_str(), f.c_str(), a.c_str());
}


void ShuttleSquad::setGoal(TilePosition mGoal) {
	if (isActive() && baseHarass) {
		TilePosition ePos = ExplorationManager::getInstance()->getClosestSpottedBuilding(Broodwar->self()->getStartLocation());
		if (ePos.x() == -1) {
			TilePosition nGoal = getNextStartLocation();
			if (nGoal.x() >= 0) {
				this->goal = nGoal;
				setMemberGoals();
			}
		}
		else {
			this->goal = getClosestStartLocation(ePos);
			setMemberGoals();
		}
	}

	if (isActive() && !baseHarass) {
		if (mGoal.x() != goal.x() || mGoal.y() != goal.y()) {
			goalSetFrame = Broodwar->getFrameCount();
			this->goal = mGoal;
			setMemberGoals();
		}
	}
}

void ShuttleSquad::clearGoal() {
	if (!baseHarass) {
		this->goal = TilePosition(-1, -1);
		setMemberGoals();
	}
}

bool ShuttleSquad::hasGoal() {
	if (goal.x() < 0 || goal.y() < 0) {
		return false;
	}
	return true;
}

TilePosition ShuttleSquad::getGoal() {
	//If state == BUSY, dont let the ShuttleAgent do anything.
	if (state == BUSY) {
		return TilePosition(-1, -1);
	}

	//1. Find Shuttle Reference
	UnitAgent* shuttleRef = NULL;
	for(int i = 0; i < (int)agents.size(); i++) {
		if(UnitAgent::isOfType(agents[i]->getUnit(), UnitTypes::Protoss_Shuttle)) {
			if (!agents[i]->getUnit()->isBeingConstructed()) {
				shuttleRef = (UnitAgent*)agents[i];
				break;
			}
		}
	}
	if (shuttleRef == NULL) {
		//No Shuttle, nothing to do.
		return TilePosition(-1, -1);
	}

	if (isActive()) {

		//Case 1: We have two Reavers loaded. Move to goal.
		if (shuttleRef->getUnit()->getLoadedUnits().size() == 2) {
			return goal;
		}

		//Case 2: We have 0 Reavers, move back to base.
		if (shuttleRef->getUnit()->getLoadedUnits().size() == 0) {
			return Broodwar->self()->getStartLocation();
		}

		//Case 3: We have one Reaver loaded, stay where you are.
		if (shuttleRef->getUnit()->getLoadedUnits().size() == 1) {
			return shuttleRef->getUnit()->getTilePosition();
		}
	}
	else {
		//Not ready yet. Do nothing.
		return TilePosition(-1, -1);
	}

	return TilePosition(-1, -1);
}
