#include "ShuttleAgent.h"
#include "PFManager.h"
#include "AgentManager.h"
#include "Squad.h"
#include "Commander.h"

ShuttleAgent::ShuttleAgent(Unit* mUnit) {
	unit = mUnit;
	unitID = unit->getID();
	//Broodwar->printf("ShuttleAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
}

void ShuttleAgent::computeActions() {
	//The ShuttleSquad is deciding what the Shuttle shall do.
	Squad* squad = Commander::getInstance()->getSquad(squadID);
	if (squad != NULL) {
		goal = squad->getGoal();

		//PFManager::getInstance()->computeAttackingUnitActions(this, goal, true);

		if (goal.x() >= 0) {
			unit->rightClick(Position(goal));
		}
	}
}

string ShuttleAgent::getTypeName() {
	return "ShuttleAgent";
}
