#include "RushSquad.h"
#include "UnitAgent.h"
#include "AgentManager.h"
#include "ExplorationManager.h"
#include "Commander.h"

RushSquad::RushSquad(int mId, string mName, int mMoveType, int mPriority) {
	this->id = mId;
	this->type = RUSH;
	this->moveType = mMoveType;
	this->name = mName;
	this->priority = mPriority;
	activePriority = priority;
	active = false;
	required = false;
	goal = Broodwar->self()->getStartLocation();
	goalSetFrame = 0;
}

bool RushSquad::isActive() {
	return active;
}

void RushSquad::computeActions() {
	if (!active) {
		if (isFull()) {
			//Broodwar->printf("Ready at frame %d", Broodwar->getFrameCount());
			active = true;
		}

		if (analyzed) {
			TilePosition defSpot = Commander::getInstance()->findChokePoint();
			if (defSpot.x() != -1) {
				goal = defSpot;
			}
		}
		return;
	}

	//First, remove dead agents
	for(int i = 0; i < (int)agents.size(); i++) {
		if(!agents.at(i)->isAlive()) {
			agents.erase(agents.begin() + i);
			i--;
		}
	}

	if (active) {
		if (activePriority != priority) {
			priority = activePriority;
		}

		Unit* target = findWorkerTarget();
		if (target != NULL) {
			for (int i = 0; i < (int)agents.size(); i++) {
				BaseAgent* agent = agents.at(i);
				if (agent->isAlive()) {
					agent->getUnit()->attack(target);
				}
			}
		}

		TilePosition ePos = ExplorationManager::getInstance()->getClosestSpottedBuilding(Broodwar->self()->getStartLocation());
		if (ePos.x() == -1) {
			TilePosition nGoal = getNextStartLocation();
			if (nGoal.x() >= 0) {
				this->goal = nGoal;
				setMemberGoals();
			}
		}
		else {
			this->goal = ePos;//getClosestStartLocation(ePos);
			setMemberGoals();
		}

		checkAttack();
	}
}

Unit* RushSquad::findWorkerTarget() {
	try {
		double maxRange = 12 * 32;

		for (int i = 0; i < (int)agents.size(); i++) {
			BaseAgent* agent = agents.at(i);

			for(set<Unit*>::const_iterator i=Broodwar->enemy()->getUnits().begin();i!=Broodwar->enemy()->getUnits().end();i++) {
				if ((*i)->exists()) {
					if ((*i)->getType().isWorker()) {
						double dist = agent->getUnit()->getDistance((*i));
						if (dist <= maxRange) {
							return (*i);
						}
					}	
				}
			}
		}
	}
	catch (exception) {

	}

	return NULL;
}

void RushSquad::printInfo() {
	string f = "NotFull";
	if (isFull()) {
		f = "Full";
	}
	string a = "Inactive";
	if (isActive()) {
		a = "Active";
	}

	Broodwar->printf("[RushSquad %d] (%s, %s) Goal: (%d,%d) prio: %d", id, f.c_str(), a.c_str(), goal.x(), goal.y(), priority);
}


void RushSquad::setGoal(TilePosition mGoal) {
	//Dont do anything. The squad sets goal by itself
	this->goal = mGoal;
}

void RushSquad::clearGoal() {
	goal = TilePosition(-1, -1);
}

TilePosition RushSquad::getGoal() {
	return goal;
}

bool RushSquad::hasGoal() {
	if (goal.x() < 0 || goal.y() < 0) {
		return false;
	}
	return true;
}
