#include "ReaverAgent.h"
#include "PFManager.h"
#include "AgentManager.h"

ReaverAgent::ReaverAgent(Unit* mUnit) {
	unit = mUnit;
	unitID = unit->getID();
	//Broodwar->printf("ReaverAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
	goalSet = false;
}

void ReaverAgent::computeActions() {
	int maxLoad = 5;
	if (Broodwar->self()->getUpgradeLevel(UpgradeTypes::Reaver_Capacity) > 0) {
		maxLoad = 10;
	}

	if(unit->getScarabCount() < maxLoad) {
		unit->train(UnitTypes::Protoss_Scarab);
		return;
	}

	PFManager::getInstance()->computeAttackingUnitActions(this, goal, false);
}

void ReaverAgent::setGoal(TilePosition goal) {
	//Do nothing. This is handled from ShuttleSquad.
}

void ReaverAgent::clearGoal() {
	//Do nothing
}

string ReaverAgent::getTypeName() {
	return "ReaverAgent";
}
