#include "PFManager.h"
#include "PFFunctions.h"
#include "UnitAgent.h"
#include "AgentManager.h"
#include "ExplorationManager.h"
#include "Commander.h"
#include "Squad.h"
#include "CoverMap.h"

bool PFManager::instanceFlag = false;
PFManager* PFManager::instance = NULL;

PFManager::PFManager() {
	checkRange = 48;
	stepSize = 16;
	mapW = Broodwar->mapWidth() * 32;
	mapH = Broodwar->mapHeight() * 32;
}

PFManager::~PFManager() {
	instanceFlag = false;
	delete instance;
}

PFManager* PFManager::getInstance() {
	if (!instanceFlag) {
		instance = new PFManager();
		instanceFlag = true;
	}
	return instance;
}

void PFManager::computeMedicUnitActions(BaseAgent* agent) {
	Unit* unit = agent->getUnit();

	int unitX = unit->getPosition().x();
	int unitY = unit->getPosition().y();

	float bestP = getMedicUnitP(agent, unitX, unitY);
	float cP = 0;
	
	float startP = bestP;
	int bestX = -1;
	int bestY = -1;

	for (int cX = unitX - checkRange; cX <= unitX + checkRange; cX += stepSize) {
		for (int cY = unitY - checkRange; cY <= unitY + checkRange; cY += stepSize) {
			if (cX >= 0 && cY >= 0 && cX <= mapW && cY <= mapH) {
				cP = getMedicUnitP(agent, cX, cY);
				
				if (cP > bestP) {
					bestP = cP;
					bestX = cX;
					bestY = cY;
				}
			}
		}
	}

	if (bestX >= 0 && bestY >= 0)
	{
		Position toMove(bestX, bestY);
		unit->rightClick(toMove);
	}
}

void PFManager::computeAttackingUnitActions(BaseAgent* agent, TilePosition goal, bool defensive) {
	computeAttackingUnitActions(agent, goal, defensive, false);
}

Unit* PFManager::checkTarget(BaseAgent* agent) {
	Unit* unit = agent->getUnit();

	int gRange = unit->getType().groundWeapon().maxRange();
	if (gRange < 64) gRange = 64;
	int aRange = unit->getType().airWeapon().maxRange();
	if (aRange < 64) aRange = 64;
	int maxRange = gRange;
	if (aRange > maxRange) maxRange = aRange;

	bool targetGround = false;
	if (unit->getType().groundWeapon().targetsGround()) targetGround = true;
	if (unit->getType().airWeapon().targetsGround()) targetGround = true;
	bool targetAir = false;
	if (unit->getType().groundWeapon().targetsAir()) targetAir = true;
	if (unit->getType().airWeapon().targetsAir()) targetAir = true;

	Unit* target = NULL;

	for(set<Unit*>::const_iterator i=unit->getUnitsInRadius(maxRange).begin();i!=unit->getUnitsInRadius(maxRange).end();i++) {
		if ((*i)->exists() && (*i)->getPlayer()->getID() != Broodwar->self()->getID() && !(*i)->getPlayer()->isNeutral()) {
			UnitType eType = (*i)->getType();
			if ( (eType.isFlyer() && targetAir) || (!eType.isFlyer() && targetGround) || (eType.isFlyingBuilding() && targetAir) ) {
				//We can attack the enemy
				if (target == NULL) target = (*i);
				if (target != NULL && !eType.isBuilding()) target = (*i);
			}
		}
	}
	
	return target;
}

void PFManager::computeAttackingUnitActions(BaseAgent* agent, TilePosition goal, bool defensive, bool forceMove) {
	Unit* unit = agent->getUnit();

	if (!forceMove) {
		if (unit->getGroundWeaponCooldown() == 0) {
			Unit* target = checkTarget(agent);
			if (target != NULL) {
				//Broodwar->drawCircle(CoordinateType::Map, unit->getPosition().x(), unit->getPosition().y(), unit->getType().dimensionDown(),Colors::Blue,true);
				agent->getUnit()->attack(target);
				return;
			}
		}
	}

	int unitX = unit->getPosition().x();
	int unitY = unit->getPosition().y();

	float bestP = getAttackingUnitP(agent, unitX, unitY, defensive);
	float cP = 0;
	
	float startP = bestP;
    int bestX = -1;
    int bestY = -1;

	for (int cX = unitX - checkRange; cX <= unitX + checkRange; cX += stepSize) {
        for (int cY = unitY - checkRange; cY <= unitY + checkRange; cY += stepSize) {
            if (cX >= 0 && cY >= 0 && cX <= mapW && cY <= mapH) {
				cP = getAttackingUnitP(agent, cX, cY, defensive);
				//Broodwar->printf("p(%d,%d)=%d",cX,cY,cP);

                if (cP != bestP) {
					bestP = cP;
                    bestX = cX;
                    bestY = cY;
                }
            }
        }
    }
	
	if (bestX >= 0 && bestY >= 0)
    {
		//Broodwar->drawCircle(CoordinateType::Map, unit->getPosition().x(), unit->getPosition().y(), unit->getType().dimensionDown(),Colors::Green,false);
		Position toMove(bestX, bestY);
		if (!defensive) {
			//Offensive -> attackMove
			agent->setInfo("attack move");
			unit->attack(toMove);
		}
		else {
			//Defensive -> rightClick
			agent->setInfo("defensive move");
			unit->rightClick(toMove);
		}
    }
	else if (goal.x() != -1) {
		agent->setInfo("goal move");
		//Broodwar->drawCircle(CoordinateType::Map, unit->getPosition().x(), unit->getPosition().y(), unit->getType().dimensionDown(),Colors::Red,false);
		moveToGoal(agent, goal);
	}
}

bool PFManager::checkWait(BaseAgent* agent, TilePosition goal) {
	Unit* unit = agent->getUnit();

	Squad* sq = Commander::getInstance()->getSquad(agent->getSquadID());
	if (sq != NULL) {
		if (sq->isRush() || sq->isKite()) {
			return false;
		}
	}

	//Code to gather the squad 

	//Version 1: Stop and wait
	/*Squad* mSquad = Commander::getInstance()->getSquad(agent->getSquadID());
	if (mSquad != NULL && mSquad->isActive() && mSquad->getSize() > 1) {
		TilePosition center = mSquad->getCenter();
		TilePosition cPos = agent->getUnit()->getTilePosition();
		double dist = center.getDistance(cPos);
		if (dist >= 8) {
			double centerDist = center.getDistance(goal);
			double unitDist = cPos.getDistance(goal);
			if (unitDist < centerDist) {
				//agent->getUnit()->rightClick(Position(cPos));
				agent->getUnit()->stop();
				return true;
			}
		}
	}*/

	//Version 2: Move to center
	Squad* mSquad = Commander::getInstance()->getSquad(agent->getSquadID());
	//Broodwar->printf("Squad: %d", mSquad->getID());
	if (mSquad != NULL) {
		if (!mSquad->isAir()) {
			if (mSquad != NULL && mSquad->isActive() && mSquad->getSize() > 1) {
				BaseAgent* centerAgent = mSquad->getCenterAgent();
				if (centerAgent != NULL) {
					TilePosition center = centerAgent->getUnit()->getTilePosition();
					TilePosition cPos = agent->getUnit()->getTilePosition();
					double dist = center.getDistance(cPos);
					if (dist >= 10) {
						agent->getUnit()->attack(Position(center));
						return true;
					}
				}
			}
		}
	}

	return false;
}

bool PFManager::moveToGoal(BaseAgent* agent, TilePosition goal) {
	Unit* unit = agent->getUnit();

	if (checkWait(agent, goal)) {
		return true;
	}
	
	//Code to make sure we dont crowd defense positions by letting too
	//many units move there.
	/*if (agent->isDefending() && !agent->isOfType(UnitTypes::Terran_Siege_Tank_Tank_Mode)) {
		int noBases = AgentManager::getInstance()->countNoBases();
		if (noBases <= 1) {
			UnitAgent* ua = (UnitAgent*)agent;
			int fCnt = ua->friendlyUnitsWithinRange(goal, 4*32);
			if (fCnt >= 5) {
				unit->stop();
				return true;
			}
		}
	}*/

	Position toReach = Position(goal);
	double distToReach = toReach.getDistance(unit->getPosition());

	int engageDist = unit->getType().groundWeapon().maxRange();
	if (agent->isOfType(UnitTypes::Terran_Medic)) {
		engageDist = 6 * 32;
	}
	if (agent->isOfType(UnitTypes::Protoss_High_Templar)) {
		engageDist = 5 * 32;
	}

	if (distToReach <= engageDist) {
		agent->setInfo("Engage");
		unit->stop();
		return true;
	}
	
	//Move
	agent->setInfo("AttackMove");
	return unit->attack(toReach);
}

float PFManager::getAttackingUnitP(BaseAgent* agent, int cX, int cY, bool defensive) {
	float p = 0;
	Position pos(cX, cY);

	//Enemy Units
	int eCnt = 0;
	float p_plus = 0;
	float p_minus = 0;
	for(set<Unit*>::const_iterator i=Broodwar->enemy()->getUnits().begin();i!=Broodwar->enemy()->getUnits().end();i++) {
		//Enemy seen
		float dist = PFFunctions::getDistance(pos, (*i));
		float ptmp = PFFunctions::calcAttackingUnitP(dist, agent->getUnit(), (*i), defensive);

		if (ptmp > 0) {
			if (ptmp > p_plus) {
				p_plus = ptmp;
			}
		}
		if (ptmp < 0) {
			if (ptmp < p_minus) {
				p_minus = ptmp;
			}
		}
	}
	if (p_minus < 0) {
		p = p_minus;
	}
	else {
		p = p_plus;
	}

	//No enemy units found, use pathfinding
	if (p == 0) {
		return p;
	}
	
	//Own Units
	for(set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++) {
		float dist = PFFunctions::getDistance(pos, (*i));
		float ptmp = PFFunctions::calcOwnUnitP(dist, agent->getUnit(), (*i));

        p += ptmp;
	}

	//Neutral Units
	for(set<Unit*>::const_iterator i=Broodwar->getNeutralUnits().begin();i!=Broodwar->getNeutralUnits().end();i++) {
		float dist = PFFunctions::getDistance(pos, (*i));
		float ptmp = PFFunctions::calcMineP(dist, agent->getUnit());

        p += ptmp;
	}

	//Broodwar->printf("[%d] o=%d", agent->getUnitID(), (int)p);

	//Terrain
	if (!Broodwar->isWalkable(cX/8, cY/8)) {
		p -= 50;
	}

	//Broodwar->printf("[%d] t=%d", agent->getUnitID(), (int)p);

	return p;
}

float PFManager::getMedicUnitP(BaseAgent* agent, int cX, int cY) {
	float p = 0;
	Position pos(cX, cY);

	//Enemy Units
	int eCnt = 0;
	for(set<Unit*>::const_iterator i=Broodwar->enemy()->getUnits().begin();i!=Broodwar->enemy()->getUnits().end();i++) {
		//Enemy seen
		float dist = PFFunctions::getDistance(pos, (*i));
		float ptmp = PFFunctions::calcDefensiveUnitP(dist, agent->getUnit(), (*i));

        if (ptmp > p) {
            p = ptmp;
        }
	}
	
	//Own Units
	for(set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++) {
		float dist = PFFunctions::getDistance(pos, (*i));
		float ptmp = PFFunctions::calcOwnUnitMedicP(dist, agent->getUnit(), (*i));

        p += ptmp;
	}

	//Terrain
	if (!Broodwar->isWalkable(cX/8, cY/8)) {
		p -= 50;
	}

	return p;
}
