#ifndef __PFFUNCTIONS_H__
#define __PFFUNCTIONS_H__

#include "BaseAgent.h"
#include <BWAPI.h>

using namespace BWAPI;
using namespace std;

/** Helper class for the PFManager. Contains methods to calculate the potentials generated by own units, enemy units
 * and neutral objects in specific points.
 *
 * Author: Johan Hagelback (johan.hagelback@gmail.com)
 */
class PFFunctions {

private:
	static int getSize(UnitType type);

public:

	/** Returns the distance between two positions. */
	static float getDistance(Position p1, Position p2);

	/** Returns the distance between a unit and a position. */
	static float getDistance(Position pos, Unit* unit);

	/** Calculates the potential otherOwnUnit generates around unit at distance d. */
	static float calcOwnUnitP(float d, Unit* unit, Unit* otherOwnUnit);

	/** Calculates the potential own workers generate around themselves. Used to avoid collision
	 * at chokepoints. */
	static float calcAvoidWorkerP(float d, BaseAgent* unit, BaseAgent* oUnit);

	/** Calculates the potential a Spider Mine generates around unit at distance d. */
	static float calcMineP(float d, Unit* unit);

	/** Calculates the potential a Medic unit generates around otherOwnUnit at distance d. */
	static float calcOwnUnitMedicP(float d, Unit* unit, Unit* otherOwnUnit);
	
	/** Calculates the general potential field value at distance d used when moving towards a point. */
	static float calcNavigationP(float d);

	/** Returns the total potential for navigating from cPos to goal. */
	static float getNavigationP(Position cPos, Position goal);

	/** Calculates the potential an attacking unit generates at distance d around an enemy unit. */
	static float calcAttackingUnitP(float d, Unit* attacker, Unit* enemy, bool defensive);

	/** Calculates the potential a defensive unit generates at distance d around an enemy unit. */
	static float calcDefensiveUnitP(float d, Unit* ownUnit, Unit* enemy);

	/** Returns true if the own unit can attack the target. */
	static bool canAttack(Unit* ownUnit, Unit* target);
	
};

#endif