#include "NexusAgent.h"
#include "AgentManager.h"
#include "WorkerAgent.h"
#include "PFManager.h"
#include "BuildPlanner.h"
#include "ResourceManager.h"

NexusAgent::NexusAgent(Unit* mUnit) {
	unit = mUnit;
	unitID = unit->getID();
	//Broodwar->printf("New base created at (%d,%d)", unit->getTilePosition().x(), unit->getTilePosition().y());

	hasSentWorkers = false;
	if (AgentManager::getInstance()->countNoUnits(UnitTypes::Protoss_Nexus) == 0) {
		//We dont do this for the first Nexus.
		hasSentWorkers = true;
	}
	
	BuildPlanner::getInstance()->commandCenterBuilt();
}

void NexusAgent::computeActions() {
	if (!hasSentWorkers) {
		if (!unit->isBeingConstructed()) {
			sendWorkers();
			hasSentWorkers = true;

			BuildPlanner::getInstance()->addRefinery();

			if (AgentManager::getInstance()->countNoUnits(UnitTypes::Protoss_Forge) > 0) {
				BuildPlanner::getInstance()->addBuildingFirst(UnitTypes::Protoss_Pylon);
				BuildPlanner::getInstance()->addBuildingFirst(UnitTypes::Protoss_Photon_Cannon);
			}
		}
	}

	if (!unit->isIdle()) {
		//Already doing something
		return;
	}

	if (ResourceManager::getInstance()->needWorker()) {
		UnitType worker = Broodwar->self()->getRace().getWorker();
		if (canBuild(worker)) {
			unit->train(worker);
		}
	}
}

string NexusAgent::getTypeName() {
	return "NexusAgent";
}
