#include "MutaliskAgent.h"
#include "PFManager.h"
#include "AgentManager.h"
#include "BuildPlanner.h"
#include "Squad.h"
#include "Commander.h"

MutaliskAgent::MutaliskAgent(Unit* mUnit) {
	unit = mUnit;
	unitID = unit->getID();
	//Broodwar->printf("MutaliskAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
}

void MutaliskAgent::computeActions() {
	if (AgentManager::getInstance()->countNoUnits(UnitTypes::Zerg_Greater_Spire) > 0) {
		if (noUnitsInWeaponRange() == 0) {
			//Check if we shall morph to Guardian or Devourer
			bool guardian = true;
			Squad* sq = Commander::getInstance()->getSquad(squadID);
			if (sq != NULL) {
				string sqName = sq->getName();
				if (sqName.find("Devour") != string::npos) {
					guardian = false;
				}
			}
			
			if (guardian) {
				if (Broodwar->canMake(unit, UnitTypes::Zerg_Guardian)) {
					unit->morph(UnitTypes::Zerg_Guardian);
					return;
				}
			}
			else {
				if (Broodwar->canMake(unit, UnitTypes::Zerg_Devourer)) {
					unit->morph(UnitTypes::Zerg_Devourer);
					return;
				}
			}
		}
	}

	Squad* sq = Commander::getInstance()->getSquad(squadID);
	if (sq != NULL) {
		if (sq->isKite()) {
			computeKitingActions();
			return;
		}
	}

	//Check if we have any nasty Siege Tanks to take out.
	for(set<Unit*>::const_iterator i=Broodwar->enemy()->getUnits().begin();i!=Broodwar->enemy()->getUnits().end();i++) {
		if (isOfType((*i), UnitTypes::Terran_Siege_Tank_Siege_Mode)) {
			double dist = unit->getDistance((*i));
			if (dist <= 15 * 32) {
				unit->attack((*i));
				return;
			}
		}
	}

	bool defensive = useDefensiveMode();
	PFManager::getInstance()->computeAttackingUnitActions(this, goal, defensive);
}

string MutaliskAgent::getTypeName() {
	return "MutaliskAgent";
}
