#include "MarineAgent.h"
#include "PFManager.h"
#include "AgentManager.h"
#include "BunkerAgent.h"

MarineAgent::MarineAgent(Unit* mUnit) {
	unit = mUnit;
	unitID = unit->getID();
	//Broodwar->printf("MarineAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
}

void MarineAgent::computeActions() {
	if (currentState == BUNKERED) {
		if (!myBunker->exists()) {
			currentState = DEFEND;
		}
		if (myBunker->exists() && !unit->isLoaded()) {
			unit->rightClick(myBunker);
		}
	}
	else {
		if (Broodwar->self()->hasResearched(TechTypes::Stim_Packs)) {
			if (!unit->isStimmed() && unit->getHitPoints() >= 20) {
				if (unit->isAttacking()) {
					unit->useTech(TechTypes::Stim_Packs);
					//Broodwar->printf("[%d] Using stim packs", unitID);
					return;
				}
			}
		}

		bool defensive = false;
		if (unit->getGroundWeaponCooldown() > 0) {
			defensive = true;
		}
		PFManager::getInstance()->computeAttackingUnitActions(this, goal, defensive);
	}
}

bool MarineAgent::isBunkered() {
	if (currentState == BUNKERED) {
		return true;
	}
	return false;
}

void MarineAgent::assignToBunkerDefend(Unit* bunker) {
	currentState = BUNKERED;
	myBunker = bunker;
}

string MarineAgent::getTypeName() {
	return "MarineAgent";
}
