#include "LurkerAgent.h"
#include "PFManager.h"
#include "Commander.h"
#include "ExplorationManager.h"

LurkerAgent::LurkerAgent(Unit* mUnit) {
	unit = mUnit;
	unitID = unit->getID();
	//Broodwar->printf("LurkerAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
}

void LurkerAgent::computeActions() {
	int eCnt = enemyGroundUnitsWithinRange(unit->getType().groundWeapon().maxRange());
	eCnt += enemyAirToGroundUnitsWithinRange(unit->getType().groundWeapon().maxRange());
	if (ExplorationManager::enemyIsTerran() && eCnt == 0) {
		//Check if we have any of those nasty tanks around
		eCnt += enemySiegedTanksWithinRange(unit->getTilePosition());
	}
	
	if (eCnt > 0 && !unit->isBurrowed()) {
		if (unit->burrow()) return;
	}
	if (eCnt == 0 && unit->isBurrowed()) {
		unit->unburrow();
		return;
	}

	Squad* sq = Commander::getInstance()->getSquad(squadID);
	if (sq != NULL) {
		if (sq->isKite()) {
			computeKitingActions();
			return;
		}
	}
	
	PFManager::getInstance()->computeAttackingUnitActions(this, goal, false);
}

string LurkerAgent::getTypeName() {
	return "LurkerAgent";
}
