#include "HydraliskAgent.h"
#include "PFManager.h"
#include "Commander.h"
#include "BuildPlanner.h"

HydraliskAgent::HydraliskAgent(Unit* mUnit) {
	unit = mUnit;
	unitID = unit->getID();
	//Broodwar->printf("HydraliskAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
}

void HydraliskAgent::computeActions() {
	if (Broodwar->self()->hasResearched(TechTypes::Lurker_Aspect)) {
		if (noUnitsInWeaponRange() == 0) {
			//Check if we shall morph to Lurkers
			bool morph = false;
			Squad* sq = Commander::getInstance()->getSquad(squadID);
			if (sq != NULL) {
				string sqName = sq->getName();
				if (sqName.find("Lurker") != string::npos) {
					morph = true;
				}
			}

			if (morph) {
				if (Broodwar->canMake(unit, UnitTypes::Zerg_Lurker)) {
					unit->morph(UnitTypes::Zerg_Lurker);
					return;
				}
			}
		}
	}

	Squad* sq = Commander::getInstance()->getSquad(squadID);
	if (sq != NULL) {
		if (sq->isKite()) {
			computeKitingActions();
			return;
		}
	}

	PFManager::getInstance()->computeAttackingUnitActions(this, goal, false);
}

string HydraliskAgent::getTypeName() {
	return "HydraliskAgent";
}
