#ifndef __HARASSSQUAD_H__
#define __HARASSSQUAD_H__

#include "BaseAgent.h"
#include "Squad.h"

using namespace BWAPI;
using namespace std;

/** This squad locates vulnerable bases and attacks them. A base is considered vulnerable if it is not
 * protected by towers. The squad is most effective if it contists of cloaking units.
 *
 * Author: Johan Hagelback (johan.hagelback@gmail.com)
 */
class HarassSquad : public Squad {

private:
	int lastCheckFrame;
	
public:
	/** Creates a Shuttle squad with a unique id and a name
	* (for example AirAttackSquad, MainGroundSquad). */
	HarassSquad(int mId, string mName, int mPriority);

	/** Returns true if this Squad is active, or false if not.
	 * A Squad is active when it first has been filled with agents.
	 * A Squad with destroyed units are still considered Active. */
	bool isActive();

	/** Called each update to issue orders. */
	void computeActions();

	/** Sets the goal for this Squad. */
	void setGoal(TilePosition mGoal);

	/** Clears the goal for this Squad, i.e. sets the goal
	 * to TilePosition(-1,-1). */
	void clearGoal();

	/** Returns the current goal of this Squad. */
	TilePosition getGoal();

	/** Returns true if this squad has an assigned goal. */
	bool hasGoal();

	/** Prints some info about the squad. */
	void printInfo();
};

#endif