#include "HarassSquad.h"
#include "UnitAgent.h"
#include "ExplorationManager.h"
#include "Commander.h"

HarassSquad::HarassSquad(int mId, string mName, int mPriority) {
	this->id = mId;
	this->type = OFFENSIVE;
	this->moveType = GROUND;
	this->name = mName;
	this->priority = mPriority;
	activePriority = priority;
	active = false;
	required = false;
	lastCheckFrame = 0;
	goal = Broodwar->self()->getStartLocation();
	goalSetFrame = 0;
}

bool HarassSquad::isActive() {
	return active;
}

void HarassSquad::computeActions() {
	if (!active) {

		if (isFull()) {
			active = true;
		}

		if (analyzed) {
			TilePosition defSpot = Commander::getInstance()->findChokePoint();
			if (defSpot.x() != -1) {
				goal = defSpot;
			}
		}
		return;
	}

	//First, remove dead agents
	for(int i = 0; i < (int)agents.size(); i++) {
		if(!agents.at(i)->isAlive()) {
			agents.erase(agents.begin() + i);
			i--;
		}
	}

	//All units dead, go back to inactive
	if ((int)agents.size() == 0) {
		active = false;
		return;
	}

	if (active) {
		if (activePriority != priority) {
			priority = activePriority;
		}

		int cFrame = Broodwar->getFrameCount();
		if (cFrame - lastCheckFrame >= 250) {
			//Check for target to attack
			TilePosition pos = ExplorationManager::getInstance()->scanForVulnerableBase();
			if (pos.x() >= 0) {
				if (pos.x() != goal.x() || pos.y() != goal.y()) {
					Broodwar->printf("[HarassSquad %d]: Attacking vulnerable base at (%d,%d)", id, pos.x(), pos.y());
				}
				goal = pos;
				setMemberGoals();
			}
			else {
				goal = Broodwar->self()->getStartLocation();
				setMemberGoals();
			}
		}
	}
}

void HarassSquad::printInfo() {
	string f = "NotFull";
	if (isFull()) {
		f = "Full";
	}
	string a = "Inactive";
	if (isActive()) {
		a = "Active";
	}

	Broodwar->printf("[HarassSquad %d] %s (%s, %s)", id, name.c_str(), f.c_str(), a.c_str());
}


void HarassSquad::setGoal(TilePosition mGoal) {
	//Dont do anything. The squad sets goal by itself
}

void HarassSquad::clearGoal() {
	
}

TilePosition HarassSquad::getGoal() {
	return goal;
}

bool HarassSquad::hasGoal() {
	if (goal.x() < 0 || goal.y() < 0) {
		return false;
	}
	return true;
}
