#include "GuardianAgent.h"
#include "PFManager.h"
#include "AgentManager.h"
#include "Commander.h"

GuardianAgent::GuardianAgent(Unit* mUnit) {
	unit = mUnit;
	unitID = unit->getID();
	//Broodwar->printf("GuardianAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
}

void GuardianAgent::computeActions() {
	Squad* sq = Commander::getInstance()->getSquad(squadID);
	if (sq != NULL) {
		if (sq->isKite()) {
			computeKitingActions();
			return;
		}
	}

	bool defensive = useDefensiveMode();
	PFManager::getInstance()->computeAttackingUnitActions(this, goal, defensive);
}

string GuardianAgent::getTypeName() {
	return "GuardianAgent";
}
