#include "GoliathAgent.h"
#include "PFManager.h"
#include "AgentManager.h"

GoliathAgent::GoliathAgent(Unit* mUnit) {
	unit = mUnit;
	unitID = unit->getID();
	//Broodwar->printf("GoliathAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
}

void GoliathAgent::computeActions() {
	//Check if we have enemy flying units nearby, if so attack them as prio 1.
	for(set<Unit*>::const_iterator i=Broodwar->enemy()->getUnits().begin();i!=Broodwar->enemy()->getUnits().end();i++) {
		if ((*i)->getType().isFlyer()) {
			double dist = unit->getDistance((*i));
			if (dist <= 224) {
				unit->attack((*i));
				return;
			}
		}
	}

	PFManager::getInstance()->computeAttackingUnitActions(this, goal, false);
}

string GoliathAgent::getTypeName() {
	return "GoliathAgent";
}
