#include "FirebatAgent.h"
#include "PFManager.h"
#include "AgentManager.h"
#include "BunkerAgent.h"

FirebatAgent::FirebatAgent(Unit* mUnit) {
	unit = mUnit;
	unitID = unit->getID();
	//Broodwar->printf("FirebatAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
}

void FirebatAgent::computeActions() {
	if (currentState == BUNKERED) {
		if (!myBunker->exists()) {
			currentState = DEFEND;
		}
		if (myBunker->exists() && !unit->isLoaded()) {
			unit->rightClick(myBunker);
		}
	}
	else {
		if (Broodwar->self()->hasResearched(TechTypes::Stim_Packs)) {
			if (!unit->isStimmed() && unit->getHitPoints() >= 20) {
				if (unit->isAttacking()) {
					unit->useTech(TechTypes::Stim_Packs);
					//Broodwar->printf("[%d] Using stim packs", unitID);
					return;
				}
			}
		}

		PFManager::getInstance()->computeAttackingUnitActions(this, goal, false);
	}
}

bool FirebatAgent::isBunkered() {
	if (currentState == BUNKERED) {
		return true;
	}
	return false;
}

void FirebatAgent::assignToBunkerDefend(Unit* bunker) {
	currentState = BUNKERED;
	unit->rightClick(bunker);
	myBunker = bunker;
}

string FirebatAgent::getTypeName() {
	return "FirebatAgent";
}
