#include "ExplorationSquad.h"
#include "UnitAgent.h"
#include "ExplorationManager.h"

ExplorationSquad::ExplorationSquad(int mId, string mName, int mMoveType, int mPriority) {
	this->id = mId;
	this->type = EXPLORER;
	this->moveType = mMoveType;
	this->name = mName;
	this->priority = mPriority;
	activePriority = priority;
	active = false;
	required = false;
	goal = Broodwar->self()->getStartLocation();
	goalSetFrame = 0;
}

bool ExplorationSquad::isActive() {
	return active;
}

void ExplorationSquad::computeActions() {
	if (!active) {
		if (isFull()) {
			active = true;
		}
		return;
	}

	//First, remove dead agents
	for(int i = 0; i < (int)agents.size(); i++) {
		if(!agents.at(i)->isAlive()) {
			agents.erase(agents.begin() + i);
			i--;
		}
	}

	//All units dead, go back to inactive
	if ((int)agents.size() == 0) {
		active = false;
		return;
	}

	if (active) {
		if (activePriority != priority) {
			priority = activePriority;
		}

		TilePosition nGoal = ExplorationManager::getInstance()->getNextToExplore(this);
		if (nGoal.x() >= 0) {
			this->goal = nGoal;
			setMemberGoals();
		}
	}
}

void ExplorationSquad::printInfo() {
	string f = "NotFull";
	if (isFull()) {
		f = "Full";
	}
	string a = "Inactive";
	if (isActive()) {
		a = "Active";
	}

	Broodwar->printf("[ExplorationSquad %d] (%s, %s) Goal: (%d,%d) prio: %d", id, f.c_str(), a.c_str(), goal.x(), goal.y(), priority);
}

void ExplorationSquad::setGoal(TilePosition mGoal) {
	//Dont do anything. The squad sets goal by itself
}

void ExplorationSquad::clearGoal() {
	
}

TilePosition ExplorationSquad::getGoal() {
	return goal;
}

bool ExplorationSquad::hasGoal() {
	if (goal.x() < 0 || goal.y() < 0) {
		return false;
	}
	return true;
}
